/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.LocalVariableTypeTable_attribute;
import com.sun.tools.classfile.Signature;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class LocalVariableTypeTableWriter
extends InstructionDetailWriter {
    private ClassWriter classWriter;
    private Code_attribute codeAttr;
    private Map<Integer, List<LocalVariableTypeTable_attribute.Entry>> pcMap;

    static LocalVariableTypeTableWriter instance(Context context) {
        LocalVariableTypeTableWriter localVariableTypeTableWriter = context.get(LocalVariableTypeTableWriter.class);
        if (localVariableTypeTableWriter == null) {
            localVariableTypeTableWriter = new LocalVariableTypeTableWriter(context);
        }
        return localVariableTypeTableWriter;
    }

    protected LocalVariableTypeTableWriter(Context context) {
        super(context);
        context.put(LocalVariableTypeTableWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute code_attribute) {
        this.codeAttr = code_attribute;
        this.pcMap = new HashMap<Integer, List<LocalVariableTypeTable_attribute.Entry>>();
        LocalVariableTypeTable_attribute localVariableTypeTable_attribute = (LocalVariableTypeTable_attribute)code_attribute.attributes.get("LocalVariableTypeTable");
        if (localVariableTypeTable_attribute == null) {
            return;
        }
        for (int i = 0; i < localVariableTypeTable_attribute.local_variable_table.length; ++i) {
            LocalVariableTypeTable_attribute.Entry entry = localVariableTypeTable_attribute.local_variable_table[i];
            this.put(entry.start_pc, entry);
            this.put(entry.start_pc + entry.length, entry);
        }
    }

    @Override
    public void writeDetails(Instruction instruction) {
        int n = instruction.getPC();
        this.writeLocalVariables(n, NoteKind.END);
        this.writeLocalVariables(n, NoteKind.START);
    }

    @Override
    public void flush() {
        int n = this.codeAttr.code_length;
        this.writeLocalVariables(n, NoteKind.END);
    }

    public void writeLocalVariables(int n, NoteKind noteKind) {
        ConstantPool constantPool = this.classWriter.getClassFile().constant_pool;
        String string = this.space(2);
        List<LocalVariableTypeTable_attribute.Entry> list = this.pcMap.get(n);
        if (list != null) {
            ListIterator<LocalVariableTypeTable_attribute.Entry> listIterator = list.listIterator(noteKind == NoteKind.END ? list.size() : 0);
            while (noteKind == NoteKind.END ? listIterator.hasPrevious() : listIterator.hasNext()) {
                LocalVariableTypeTable_attribute.Entry entry = noteKind == NoteKind.END ? listIterator.previous() : listIterator.next();
                if (!noteKind.match(entry, n)) continue;
                this.print(string);
                this.print(noteKind.text);
                this.print(" generic local ");
                this.print(entry.index);
                this.print(" // ");
                Signature signature = new Signature(entry.signature_index);
                try {
                    this.print(((Descriptor)signature).getFieldType(constantPool).toString().replace("/", "."));
                }
                catch (Descriptor.InvalidDescriptor invalidDescriptor) {
                    this.print(this.report(invalidDescriptor));
                }
                catch (ConstantPoolException constantPoolException) {
                    this.print(this.report(constantPoolException));
                }
                this.print(" ");
                try {
                    this.print(constantPool.getUTF8Value(entry.name_index));
                }
                catch (ConstantPoolException constantPoolException) {
                    this.print(this.report(constantPoolException));
                }
                this.println();
            }
        }
    }

    private void put(int n, LocalVariableTypeTable_attribute.Entry entry) {
        List<LocalVariableTypeTable_attribute.Entry> list = this.pcMap.get(n);
        if (list == null) {
            list = new ArrayList<LocalVariableTypeTable_attribute.Entry>();
            this.pcMap.put(n, list);
        }
        if (!list.contains(entry)) {
            list.add(entry);
        }
    }

    public static enum NoteKind {
        START("start"){

            @Override
            public boolean match(LocalVariableTypeTable_attribute.Entry entry, int n) {
                return n == entry.start_pc;
            }
        }
        ,
        END("end"){

            @Override
            public boolean match(LocalVariableTypeTable_attribute.Entry entry, int n) {
                return n == entry.start_pc + entry.length;
            }
        };

        public final String text;

        private NoteKind(String string2) {
            this.text = string2;
        }

        public abstract boolean match(LocalVariableTypeTable_attribute.Entry var1, int var2);
    }
}

