/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public abstract class Gen {
    protected String lineSep = System.getProperty("line.separator");
    protected ProcessingEnvironment processingEnvironment;
    protected Types types;
    protected Elements elems;
    protected Mangle mangler;
    protected Util util;
    protected Set<TypeElement> classes;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    protected JavaFileManager fileManager;
    protected JavaFileObject outFile;
    protected boolean force = false;

    protected Gen(Util util) {
        this.util = util;
    }

    protected abstract void write(OutputStream var1, TypeElement var2) throws Util.Exit;

    protected abstract String getIncludes();

    public void setFileManager(JavaFileManager javaFileManager) {
        this.fileManager = javaFileManager;
    }

    public void setOutFile(JavaFileObject javaFileObject) {
        this.outFile = javaFileObject;
    }

    public void setClasses(Set<TypeElement> set) {
        this.classes = set;
    }

    void setProcessingEnvironment(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.elems = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
        this.mangler = new Mangle(this.elems, this.types);
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    protected PrintWriter wrapWriter(OutputStream outputStream) throws Util.Exit {
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(outputStream, "ISO8859_1"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.util.bug("encoding.iso8859_1.not.found");
            return null;
        }
    }

    public void run() throws IOException, ClassNotFoundException, Util.Exit {
        boolean bl = false;
        if (this.outFile != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            this.writeFileTop(byteArrayOutputStream);
            for (TypeElement typeElement : this.classes) {
                this.write(byteArrayOutputStream, typeElement);
            }
            this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.outFile);
        } else {
            for (TypeElement typeElement : this.classes) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                this.writeFileTop(byteArrayOutputStream);
                this.write(byteArrayOutputStream, typeElement);
                this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.getFileObject(typeElement.getQualifiedName()));
            }
        }
    }

    private void writeIfChanged(byte[] byArray, FileObject fileObject) throws IOException {
        Closeable closeable;
        boolean bl = false;
        String string = "[No need to update file ";
        if (this.force) {
            bl = true;
            string = "[Forcefully writing file ";
        } else {
            try {
                closeable = fileObject.openInputStream();
                byte[] byArray2 = this.readBytes((InputStream)closeable);
                if (!Arrays.equals(byArray2, byArray)) {
                    bl = true;
                    string = "[Overwriting file ";
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = true;
                string = "[Creating file ";
            }
        }
        if (this.util.verbose) {
            this.util.log(string + fileObject + "]");
        }
        if (bl) {
            closeable = fileObject.openOutputStream();
            ((OutputStream)closeable).write(byArray);
            ((OutputStream)closeable).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream inputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[inputStream.available() + 1];
            int n2 = 0;
            while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
                if ((n2 += n) != byArray.length) continue;
                byArray = Arrays.copyOf(byArray, byArray.length * 2);
            }
            byte[] byArray2 = Arrays.copyOf(byArray, n2);
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    protected String defineForStatic(TypeElement typeElement, VariableElement variableElement) throws Util.Exit {
        Name name = typeElement.getQualifiedName();
        Name name2 = variableElement.getSimpleName();
        String string = this.mangler.mangle(name, 1);
        String string2 = this.mangler.mangle(name2, 2);
        if (!variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.util.bug("tried.to.define.non.static");
        }
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            Object object = null;
            object = variableElement.getConstantValue();
            if (object != null) {
                Comparable<Character> comparable;
                String string3 = null;
                if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
                    string3 = object.toString() + "L";
                } else if (object instanceof Boolean) {
                    string3 = (Boolean)object != false ? "1L" : "0L";
                } else if (object instanceof Character) {
                    comparable = (Character)object;
                    string3 = String.valueOf(((Character)comparable).charValue() & 0xFFFF) + "L";
                } else if (object instanceof Long) {
                    string3 = isWindows ? object.toString() + "i64" : object.toString() + "LL";
                } else if (object instanceof Float) {
                    float f = ((Float)object).floatValue();
                    string3 = Float.isInfinite(f) ? (f < 0.0f ? "-" : "") + "Inff" : object.toString() + "f";
                } else if (object instanceof Double) {
                    double d = (Double)object;
                    string3 = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : object.toString();
                }
                if (string3 != null) {
                    comparable = new StringBuffer("#undef ");
                    ((StringBuffer)comparable).append(string);
                    ((StringBuffer)comparable).append("_");
                    ((StringBuffer)comparable).append(string2);
                    ((StringBuffer)comparable).append(this.lineSep);
                    ((StringBuffer)comparable).append("#define ");
                    ((StringBuffer)comparable).append(string);
                    ((StringBuffer)comparable).append("_");
                    ((StringBuffer)comparable).append(string2);
                    ((StringBuffer)comparable).append(" ");
                    ((StringBuffer)comparable).append(string3);
                    return ((StringBuffer)comparable).toString();
                }
            }
        }
        return null;
    }

    protected String cppGuardBegin() {
        return "#ifdef __cplusplus" + this.lineSep + "extern \"C\" {" + this.lineSep + "#endif";
    }

    protected String cppGuardEnd() {
        return "#ifdef __cplusplus" + this.lineSep + "}" + this.lineSep + "#endif";
    }

    protected String guardBegin(String string) {
        return "/* Header for class " + string + " */" + this.lineSep + this.lineSep + "#ifndef _Included_" + string + this.lineSep + "#define _Included_" + string;
    }

    protected String guardEnd(String string) {
        return "#endif";
    }

    protected void writeFileTop(OutputStream outputStream) throws Util.Exit {
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println("/* DO NOT EDIT THIS FILE - it is machine generated */" + this.lineSep + this.getIncludes());
    }

    protected String baseFileName(CharSequence charSequence) {
        return this.mangler.mangle(charSequence, 1);
    }

    protected FileObject getFileObject(CharSequence charSequence) throws IOException {
        String string = this.baseFileName(charSequence) + this.getFileSuffix();
        return this.fileManager.getFileForOutput(StandardLocation.SOURCE_OUTPUT, "", string, null);
    }

    protected String getFileSuffix() {
        return ".h";
    }

    List<VariableElement> getAllFields(TypeElement typeElement) {
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        TypeElement typeElement2 = null;
        Stack<TypeElement> stack = new Stack<TypeElement>();
        typeElement2 = typeElement;
        while (true) {
            stack.push(typeElement2);
            TypeElement typeElement3 = (TypeElement)this.types.asElement(typeElement2.getSuperclass());
            if (typeElement3 == null) break;
            typeElement2 = typeElement3;
        }
        while (!stack.empty()) {
            typeElement2 = (TypeElement)stack.pop();
            arrayList.addAll(ElementFilter.fieldsIn(typeElement2.getEnclosedElements()));
        }
        return arrayList;
    }

    String signature(ExecutableElement executableElement) {
        StringBuffer stringBuffer = new StringBuffer("(");
        String string = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            stringBuffer.append(string);
            stringBuffer.append(this.types.erasure(variableElement.asType()).toString());
            string = ",";
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

