/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MemberDocImpl;
import com.sun.tools.javadoc.TagImpl;

class SerialFieldTagImpl
extends TagImpl
implements SerialFieldTag,
Comparable<Object> {
    private String fieldName;
    private String fieldType;
    private String description;
    private ClassDoc containingClass;
    private ClassDoc fieldTypeDoc;
    private FieldDocImpl matchingField;

    SerialFieldTagImpl(DocImpl docImpl, String string, String string2) {
        super(docImpl, string, string2);
        this.parseSerialFieldString();
        if (docImpl instanceof MemberDoc) {
            this.containingClass = ((MemberDocImpl)docImpl).containingClass();
        }
    }

    private void parseSerialFieldString() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return;
        }
        for (n = 0; n < n3 && Character.isWhitespace(n2 = this.text.codePointAt(n)); n += Character.charCount(n2)) {
        }
        int n4 = n;
        int n5 = n;
        n2 = this.text.codePointAt(n);
        if (!Character.isJavaIdentifierStart(n2)) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", new String(Character.toChars(n2)), this.text);
            return;
        }
        n += Character.charCount(n2);
        while (n < n3 && Character.isJavaIdentifierPart(n2 = this.text.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        if (n < n3 && !Character.isWhitespace(n2 = this.text.codePointAt(n))) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", new String(Character.toChars(n2)), this.text);
            return;
        }
        n5 = n;
        this.fieldName = this.text.substring(n4, n5);
        while (n < n3 && Character.isWhitespace(n2 = this.text.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        n4 = n;
        n5 = n;
        while (n < n3 && !Character.isWhitespace(n2 = this.text.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        if (n < n3 && !Character.isWhitespace(n2 = this.text.codePointAt(n))) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", new String(Character.toChars(n2)), this.text);
            return;
        }
        n5 = n;
        this.fieldType = this.text.substring(n4, n5);
        while (n < n3 && Character.isWhitespace(n2 = this.text.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        this.description = this.text.substring(n);
    }

    String key() {
        return this.fieldName;
    }

    void mapToFieldDocImpl(FieldDocImpl fieldDocImpl) {
        this.matchingField = fieldDocImpl;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public String fieldType() {
        return this.fieldType;
    }

    @Override
    public ClassDoc fieldTypeDoc() {
        if (this.fieldTypeDoc == null && this.containingClass != null) {
            this.fieldTypeDoc = this.containingClass.findClass(this.fieldType);
        }
        return this.fieldTypeDoc;
    }

    FieldDocImpl getMatchingField() {
        return this.matchingField;
    }

    @Override
    public String description() {
        Comment comment;
        if (this.description.length() == 0 && this.matchingField != null && (comment = this.matchingField.comment()) != null) {
            return comment.commentText();
        }
        return this.description;
    }

    @Override
    public String kind() {
        return "@serialField";
    }

    @Override
    public String toString() {
        return this.name + ":" + this.text;
    }

    @Override
    public int compareTo(Object object) {
        return this.key().compareTo(((SerialFieldTagImpl)object).key());
    }
}

