/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.CollationKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.FileObject;

public abstract class DocImpl
implements Doc,
Comparable<Object> {
    protected final DocEnv env;
    private Comment comment;
    private CollationKey collationkey = null;
    protected String documentation;
    private Tag[] firstSentence;
    private Tag[] inlineTags;

    DocImpl(DocEnv docEnv, String string) {
        this.documentation = string;
        this.env = docEnv;
    }

    protected String documentation() {
        if (this.documentation == null) {
            this.documentation = "";
        }
        return this.documentation;
    }

    Comment comment() {
        if (this.comment == null) {
            this.comment = new Comment(this, this.documentation());
        }
        return this.comment;
    }

    @Override
    public String commentText() {
        return this.comment().commentText();
    }

    @Override
    public Tag[] tags() {
        return this.comment().tags();
    }

    @Override
    public Tag[] tags(String string) {
        return this.comment().tags(string);
    }

    @Override
    public SeeTag[] seeTags() {
        return this.comment().seeTags();
    }

    @Override
    public Tag[] inlineTags() {
        if (this.inlineTags == null) {
            this.inlineTags = Comment.getInlineTags(this, this.commentText());
        }
        return this.inlineTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag[] firstSentenceTags() {
        if (this.firstSentence == null) {
            this.inlineTags();
            try {
                this.env.setSilent(true);
                this.firstSentence = Comment.firstSentenceTags(this, this.commentText());
            }
            finally {
                this.env.setSilent(false);
            }
        }
        return this.firstSentence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readHTMLDocumentation(InputStream inputStream, FileObject fileObject) throws IOException {
        Object object;
        byte[] byArray = new byte[inputStream.available()];
        try {
            object = new DataInputStream(inputStream);
            ((DataInputStream)object).readFully(byArray);
        }
        finally {
            inputStream.close();
        }
        object = this.env.getEncoding();
        String string = object != null ? new String(byArray, (String)object) : new String(byArray);
        Pattern pattern = Pattern.compile("(?is).*<body\\b[^>]*>(.*)</body\\b.*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        String string2 = string.matches("(?is).*<body\\b.*") ? "javadoc.End_body_missing_from_html_file" : "javadoc.Body_missing_from_html_file";
        this.env.error(SourcePositionImpl.make(fileObject, -1, null), string2);
        return "";
    }

    @Override
    public String getRawCommentText() {
        return this.documentation();
    }

    @Override
    public void setRawCommentText(String string) {
        this.documentation = string;
        this.comment = null;
    }

    CollationKey key() {
        if (this.collationkey == null) {
            this.collationkey = this.generateKey();
        }
        return this.collationkey;
    }

    CollationKey generateKey() {
        String string = this.name();
        return this.env.doclocale.collator.getCollationKey(string);
    }

    public String toString() {
        return this.qualifiedName();
    }

    @Override
    public abstract String name();

    public abstract String qualifiedName();

    @Override
    public int compareTo(Object object) {
        return this.key().compareTo(((DocImpl)object).key());
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isMethod() {
        return false;
    }

    @Override
    public boolean isAnnotationTypeElement() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isException() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public abstract boolean isIncluded();

    @Override
    public SourcePosition position() {
        return null;
    }
}

