/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName optionName) {
            super(optionName, null, null);
        }

        HiddenOption(OptionName optionName, String string) {
            super(optionName, string, null);
        }

        @Override
        void help(PrintWriter printWriter) {
        }

        @Override
        void xhelp(PrintWriter printWriter) {
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;
        ChoiceKind choiceKind;
        Map<String, Boolean> choices;

        Option(OptionName optionName, String string, String string2) {
            this.name = optionName;
            this.argsNameKey = string;
            this.descrKey = string2;
            char c = optionName.optionName.charAt(optionName.optionName.length() - 1);
            this.hasSuffix = c == ':' || c == '=';
        }

        Option(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        Option(OptionName optionName, String string, ChoiceKind choiceKind, String ... stringArray) {
            this(optionName, string, choiceKind, Option.createChoices(stringArray));
        }

        private static Map<String, Boolean> createChoices(String ... stringArray) {
            LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
            for (String string : stringArray) {
                linkedHashMap.put(string, false);
            }
            return linkedHashMap;
        }

        Option(OptionName optionName, String string, ChoiceKind choiceKind, Map<String, Boolean> map) {
            this(optionName, null, string);
            if (choiceKind == null || map == null) {
                throw new NullPointerException();
            }
            this.choiceKind = choiceKind;
            this.choices = map;
        }

        public String toString() {
            return this.name.optionName;
        }

        @Override
        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        @Override
        public boolean matches(String string) {
            if (!this.hasSuffix) {
                return string.equals(this.name.optionName);
            }
            if (!string.startsWith(this.name.optionName)) {
                return false;
            }
            if (this.choices != null) {
                String string2 = string.substring(this.name.optionName.length());
                if (this.choiceKind == ChoiceKind.ONEOF) {
                    return this.choices.keySet().contains(string2);
                }
                for (String string3 : string2.split(",+")) {
                    if (this.choices.keySet().contains(string3)) continue;
                    return false;
                }
            }
            return true;
        }

        void help(PrintWriter printWriter) {
            String string = "  " + this.helpSynopsis();
            printWriter.print(string);
            for (int i = Math.min(string.length(), 28); i < 29; ++i) {
                printWriter.print(" ");
            }
            Log.printLines((PrintWriter)printWriter, (String)Main.getLocalizedString((String)this.descrKey, (Object[])new Object[0]));
        }

        String helpSynopsis() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.name);
            if (this.argsNameKey == null) {
                if (this.choices != null) {
                    String string = "{";
                    for (Map.Entry<String, Boolean> entry : this.choices.entrySet()) {
                        if (entry.getValue().booleanValue()) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(entry.getKey());
                        string = ",";
                    }
                    stringBuilder.append("}");
                }
            } else {
                if (!this.hasSuffix) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(Main.getLocalizedString((String)this.argsNameKey, (Object[])new Object[0]));
            }
            return stringBuilder.toString();
        }

        void xhelp(PrintWriter printWriter) {
        }

        @Override
        public boolean process(Options options, String string, String string2) {
            if (options != null) {
                if (this.choices != null) {
                    if (this.choiceKind == ChoiceKind.ONEOF) {
                        String string32;
                        for (String string32 : this.choices.keySet()) {
                            options.remove(string + string32);
                        }
                        String string4 = string + string2;
                        options.put(string4, string4);
                        string32 = string.substring(0, string.length() - 1);
                        options.put(string32, string2);
                    } else {
                        for (String string5 : string2.split(",+")) {
                            String string6 = string + string5;
                            options.put(string6, string6);
                        }
                    }
                }
                options.put(string, string2);
            }
            return false;
        }

        @Override
        public boolean process(Options options, String string) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, string.substring(this.name.optionName.length()));
            }
            return this.process(options, string, string);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        @Override
        public OptionName getName() {
            return this.name;
        }
    }

    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }

    public static class XOption
    extends Option {
        XOption(OptionName optionName, String string, String string2) {
            super(optionName, string, string2);
        }

        XOption(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        XOption(OptionName optionName, String string, ChoiceKind choiceKind, String ... stringArray) {
            super(optionName, string, choiceKind, stringArray);
        }

        XOption(OptionName optionName, String string, ChoiceKind choiceKind, Map<String, Boolean> map) {
            super(optionName, string, choiceKind, map);
        }

        @Override
        void help(PrintWriter printWriter) {
        }

        @Override
        void xhelp(PrintWriter printWriter) {
            super.help(printWriter);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }
}

