/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.Multiplicity;
import com.sun.tools.internal.xjc.reader.RawTypeSet;
import com.sun.tools.internal.xjc.reader.gbind.ConnectedComponent;
import com.sun.tools.internal.xjc.reader.gbind.Element;
import com.sun.tools.internal.xjc.reader.gbind.Expression;
import com.sun.tools.internal.xjc.reader.gbind.Graph;
import com.sun.tools.internal.xjc.reader.xmlschema.ExpressionBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.GElement;
import com.sun.tools.internal.xjc.reader.xmlschema.GElementImpl;
import com.sun.tools.internal.xjc.reader.xmlschema.GWildcardElement;
import com.sun.tools.internal.xjc.reader.xmlschema.ParticleBinder;
import com.sun.tools.internal.xjc.reader.xmlschema.RawTypeSetBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.xsom.XSParticle;
import java.util.Collection;

final class ExpressionParticleBinder
extends ParticleBinder {
    ExpressionParticleBinder() {
    }

    @Override
    public void build(XSParticle p, Collection<XSParticle> forcedProps) {
        Expression tree = ExpressionBuilder.createTree(p);
        Graph g2 = new Graph(tree);
        for (ConnectedComponent cc : g2) {
            this.buildProperty(cc);
        }
    }

    private void buildProperty(ConnectedComponent cc) {
        StringBuilder propName = new StringBuilder();
        int nameTokenCount = 0;
        RawTypeSetBuilder rtsb = new RawTypeSetBuilder();
        for (Element e : cc) {
            GElement ge = (GElement)e;
            if (nameTokenCount < 3) {
                if (nameTokenCount != 0) {
                    propName.append("And");
                }
                propName.append(this.makeJavaName(cc.isCollection(), ge.getPropertyNameSeed()));
                ++nameTokenCount;
            }
            if (e instanceof GElementImpl) {
                GElementImpl ei = (GElementImpl)e;
                rtsb.elementDecl(ei.decl);
                continue;
            }
            if (e instanceof GWildcardElement) {
                GWildcardElement w = (GWildcardElement)e;
                rtsb.getRefs().add(new RawTypeSetBuilder.WildcardRef(w.isStrict() ? WildcardMode.STRICT : WildcardMode.SKIP));
                continue;
            }
            assert (false) : e;
        }
        Multiplicity m3 = Multiplicity.ONE;
        if (cc.isCollection()) {
            m3 = m3.makeRepeated();
        }
        if (!cc.isRequired()) {
            m3 = m3.makeOptional();
        }
        RawTypeSet rts = new RawTypeSet(rtsb.getRefs(), m3);
        XSParticle p = this.findSourceParticle(cc);
        BIProperty cust = BIProperty.getCustomization(p);
        CPropertyInfo prop = cust.createElementOrReferenceProperty(propName.toString(), false, p, rts);
        this.getCurrentBean().addProperty(prop);
    }

    private XSParticle findSourceParticle(ConnectedComponent cc) {
        XSParticle first = null;
        for (Element e : cc) {
            GElement ge = (GElement)e;
            for (XSParticle p : ge.particles) {
                if (first == null) {
                    first = p;
                }
                if (this.getLocalPropCustomization(p) == null) continue;
                return p;
            }
        }
        return first;
    }

    @Override
    public boolean checkFallback(XSParticle p) {
        return false;
    }
}

