/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeRequiredMemberWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationTypeRequiredMemberBuilder
extends AbstractMemberBuilder {
    protected ClassDoc classDoc;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeRequiredMemberWriter writer;
    protected List<ProgramElementDoc> members;
    protected int currentMemberIndex;

    protected AnnotationTypeRequiredMemberBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeRequiredMemberBuilder getInstance(Configuration configuration, ClassDoc classDoc, AnnotationTypeRequiredMemberWriter annotationTypeRequiredMemberWriter) {
        AnnotationTypeRequiredMemberBuilder annotationTypeRequiredMemberBuilder = new AnnotationTypeRequiredMemberBuilder(configuration);
        annotationTypeRequiredMemberBuilder.classDoc = classDoc;
        annotationTypeRequiredMemberBuilder.writer = annotationTypeRequiredMemberWriter;
        annotationTypeRequiredMemberBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 6, configuration.nodeprecated);
        annotationTypeRequiredMemberBuilder.members = new ArrayList<ProgramElementDoc>(annotationTypeRequiredMemberBuilder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(annotationTypeRequiredMemberBuilder.members, configuration.getMemberComparator());
        }
        return annotationTypeRequiredMemberBuilder;
    }

    @Override
    public String getName() {
        return "AnnotationTypeRequiredMemberDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeRequiredMember(XMLNode xMLNode, Content content) {
        this.buildAnnotationTypeMember(xMLNode, content);
    }

    public void buildAnnotationTypeMember(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.members.size();
        if (n > 0) {
            this.writer.addAnnotationDetailsTreeHeader(this.classDoc, content);
            this.currentMemberIndex = 0;
            while (this.currentMemberIndex < n) {
                Content content2 = this.writer.getAnnotationDocTreeHeader((MemberDoc)this.members.get(this.currentMemberIndex), content);
                this.buildChildren(xMLNode, content2);
                content.addContent(this.writer.getAnnotationDoc(content2, this.currentMemberIndex == n - 1));
                ++this.currentMemberIndex;
            }
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((MemberDoc)this.members.get(this.currentMemberIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((MemberDoc)this.members.get(this.currentMemberIndex), content);
    }

    public void buildMemberComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MemberDoc)this.members.get(this.currentMemberIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((MemberDoc)this.members.get(this.currentMemberIndex), content);
    }

    public AnnotationTypeRequiredMemberWriter getWriter() {
        return this.writer;
    }
}

