/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private AnnotationTypeDoc annotationTypeDoc;
    private AnnotationTypeWriter writer;
    private Content contentTree;

    private AnnotationTypeBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeBuilder getInstance(Configuration configuration, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter annotationTypeWriter) throws Exception {
        AnnotationTypeBuilder annotationTypeBuilder = new AnnotationTypeBuilder(configuration);
        annotationTypeBuilder.configuration = configuration;
        annotationTypeBuilder.annotationTypeDoc = annotationTypeDoc;
        annotationTypeBuilder.writer = annotationTypeWriter;
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return annotationTypeBuilder;
    }

    @Override
    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(XMLNode xMLNode, Content content) throws Exception {
        content = this.writer.getHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
        Content content2 = this.writer.getAnnotationContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
        this.writer.addFooter(content);
        this.writer.printDocument(content);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc packageDoc = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, packageDoc) >= 0 || containingPackagesSeen.contains(packageDoc.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.annotationTypeDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.annotationTypeDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(packageDoc.name());
        }
    }

    public void buildAnnotationTypeInfo(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getAnnotationInfoTreeHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(this.writer.getAnnotationInfo(content2));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeDeprecationInfo(content);
    }

    public void buildAnnotationTypeSignature(XMLNode xMLNode, Content content) {
        StringBuffer stringBuffer = new StringBuffer(this.annotationTypeDoc.modifiers() + " ");
        this.writer.addAnnotationTypeSignature(Util.replaceText(stringBuffer.toString(), "interface", "@interface"), content);
    }

    public void buildAnnotationTypeDescription(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeDescription(content);
    }

    public void buildAnnotationTypeTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeTagInfo(content);
    }

    public void buildMemberSummary(XMLNode xMLNode, Content content) throws Exception {
        Content content2 = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(xMLNode, content2);
        content.addContent(this.writer.getMemberSummaryTree(content2));
    }

    public void buildAnnotationTypeMemberDetails(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getMemberTreeHeader();
        this.buildChildren(xMLNode, content2);
        if (content2.isValid()) {
            Content content3 = this.writer.getMemberTreeHeader();
            this.writer.addAnnotationDetailsMarker(content3);
            content3.addContent(this.writer.getMemberTree(content2));
            content.addContent(this.writer.getMemberDetailsTree(content3));
        }
    }

    public void buildAnnotationTypeOptionalMemberDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildAnnotationTypeRequiredMemberDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).buildChildren(xMLNode, content);
    }
}

