/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.AbstractIndexWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(ConfigurationImpl configurationImpl, String string, String string2, String string3, IndexBuilder indexBuilder, int n, int n2) throws IOException {
        super(configurationImpl, string, string2, string3, indexBuilder);
        this.prev = n;
        this.next = n2;
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        String string = "";
        String string2 = DirectoryManager.getPath("index-files");
        String string3 = DirectoryManager.getRelativePath("index-files");
        try {
            for (int i = 0; i < indexBuilder.elements().length; ++i) {
                int n = i + 1;
                int n2 = n == 1 ? -1 : i;
                int n3 = n == indexBuilder.elements().length ? -1 : n + 1;
                string = "index-" + n + ".html";
                SplitIndexWriter splitIndexWriter = new SplitIndexWriter(configurationImpl, string2, string, string3, indexBuilder, n2, n3);
                splitIndexWriter.generateIndexFile((Character)indexBuilder.elements()[i]);
                splitIndexWriter.close();
            }
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile(Character c) throws IOException {
        String string = this.configuration.getText("doclet.Window_Split_Index", c.toString());
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(htmlTree2);
        this.addContents(c, this.indexbuilder.getMemberList(c), htmlTree2);
        this.addLinksForIndexes(htmlTree2);
        ((Content)htmlTree).addContent(htmlTree2);
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        this.printHtmlDocument(null, true, htmlTree);
    }

    protected void addLinksForIndexes(Content content) {
        Object[] objectArray = this.indexbuilder.elements();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = i + 1;
            content.addContent(this.getHyperLink("index-" + n + ".html", new StringContent(objectArray[i].toString())));
            content.addContent(this.getSpace());
        }
    }

    @Override
    public Content getNavLinkPrevious() {
        Content content = this.getResource("doclet.Prev_Letter");
        if (this.prev == -1) {
            return HtmlTree.LI(content);
        }
        Content content2 = this.getHyperLink("index-" + this.prev + ".html", "", content);
        return HtmlTree.LI(content2);
    }

    @Override
    public Content getNavLinkNext() {
        Content content = this.getResource("doclet.Next_Letter");
        if (this.next == -1) {
            return HtmlTree.LI(content);
        }
        Content content2 = this.getHyperLink("index-" + this.next + ".html", "", content);
        return HtmlTree.LI(content2);
    }
}

