/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap<String, Set<ClassDoc>> usingPackageToUsedClasses = new TreeMap<String, Set<ClassDoc>>();

    public PackageUseWriter(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, String string, PackageDoc packageDoc) throws IOException {
        super(configurationImpl, DirectoryManager.getDirectoryPath(packageDoc), string, DirectoryManager.getRelativePath(packageDoc.name()));
        this.pkgdoc = packageDoc;
        ClassDoc[] classDocArray = packageDoc.allClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            Set<ClassDoc> set = classUseMapper.classToClass.get(classDoc.qualifiedName());
            if (set == null) continue;
            for (ClassDoc classDoc2 : set) {
                PackageDoc packageDoc2 = classDoc2.containingPackage();
                TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(packageDoc2.name());
                if (treeSet == null) {
                    treeSet = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(Util.getPackageName(packageDoc2), treeSet);
                }
                treeSet.add(classDoc);
            }
        }
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, PackageDoc packageDoc) {
        String string = "package-use.html";
        try {
            PackageUseWriter packageUseWriter = new PackageUseWriter(configurationImpl, classUseMapper, string, packageDoc);
            packageUseWriter.generatePackageUseFile();
            packageUseWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageUseFile() throws IOException {
        Content content = this.getPackageUseHeader();
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.contentContainer);
        if (this.usingPackageToUsedClasses.isEmpty()) {
            htmlTree.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name()));
        } else {
            this.addPackageUse(htmlTree);
        }
        content.addContent(htmlTree);
        this.addNavLinks(false, content);
        this.addBottom(content);
        this.printHtmlDocument(null, true, content);
    }

    protected void addPackageUse(Content content) throws IOException {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
        htmlTree.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.length > 1) {
            this.addPackageList(htmlTree);
        }
        this.addClassList(htmlTree);
        content.addContent(htmlTree);
    }

    protected void addPackageList(Content content) throws IOException {
        HtmlTree htmlTree = HtmlTree.TABLE(0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration().getText("doclet.ClassUse_Packages.that.use.0", this.getPackageLinkString(this.pkgdoc, Util.getPackageName(this.pkgdoc), false))));
        ((Content)htmlTree).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
        Iterator<String> iterator = this.usingPackageToUsedClasses.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PackageDoc packageDoc = this.configuration.root.packageNamed(iterator.next());
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TR);
            if (n % 2 == 0) {
                htmlTree3.addStyle(HtmlStyle.altColor);
            } else {
                htmlTree3.addStyle(HtmlStyle.rowColor);
            }
            this.addPackageUse(packageDoc, htmlTree3);
            ((Content)htmlTree2).addContent(htmlTree3);
            ++n;
        }
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree4 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
        content.addContent(htmlTree4);
    }

    protected void addClassList(Content content) throws IOException {
        String[] stringArray = new String[]{this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description"))};
        for (String string : this.usingPackageToUsedClasses.keySet()) {
            PackageDoc packageDoc = this.configuration.root.packageNamed(string);
            HtmlTree htmlTree = new HtmlTree(HtmlTag.LI);
            htmlTree.addStyle(HtmlStyle.blockList);
            if (packageDoc != null) {
                htmlTree.addContent(this.getMarkerAnchor(packageDoc.name()));
            }
            String string2 = this.configuration.getText("doclet.Use_Table_Summary", this.configuration.getText("doclet.classes"));
            HtmlTree htmlTree2 = HtmlTree.TABLE(0, 3, 0, string2, this.getTableCaption(this.configuration().getText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLinkString(this.pkgdoc, Util.getPackageName(this.pkgdoc), false), this.getPackageLinkString(packageDoc, Util.getPackageName(packageDoc), false))));
            ((Content)htmlTree2).addContent(this.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TBODY);
            Iterator iterator = ((Set)this.usingPackageToUsedClasses.get(string)).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                HtmlTree htmlTree4 = new HtmlTree(HtmlTag.TR);
                if (n % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                this.addClassRow((ClassDoc)iterator.next(), string, htmlTree4);
                ((Content)htmlTree3).addContent(htmlTree4);
                ++n;
            }
            ((Content)htmlTree2).addContent(htmlTree3);
            htmlTree.addContent(htmlTree2);
            content.addContent(htmlTree);
        }
    }

    protected void addClassRow(ClassDoc classDoc, String string, Content content) {
        String string2 = this.pathString(classDoc, "class-use/" + classDoc.name() + ".html");
        HtmlTree htmlTree = HtmlTree.TD(HtmlStyle.colOne, this.getHyperLink(string2, string, new StringContent(classDoc.name())));
        this.addIndexComment(classDoc, htmlTree);
        content.addContent(htmlTree);
    }

    protected void addPackageUse(PackageDoc packageDoc, Content content) throws IOException {
        HtmlTree htmlTree = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink("", Util.getPackageName(packageDoc), new RawHtml(Util.getPackageName(packageDoc))));
        content.addContent(htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TD);
        htmlTree2.addStyle(HtmlStyle.colLast);
        if (packageDoc != null && packageDoc.name().length() != 0) {
            this.addSummaryComment(packageDoc, htmlTree2);
        } else {
            htmlTree2.addContent(this.getSpace());
        }
        content.addContent(htmlTree2);
    }

    protected Content getPackageUseHeader() {
        String string = this.configuration.getText("doclet.Package");
        String string2 = this.pkgdoc.name();
        String string3 = this.configuration.getText("doclet.Window_ClassUse_Header", string, string2);
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string3));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        Content content = this.getResource("doclet.ClassUse_Title", string, string2);
        HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, content);
        HtmlTree htmlTree3 = HtmlTree.DIV(HtmlStyle.header, htmlTree2);
        ((Content)htmlTree).addContent(htmlTree3);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content content = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkClassUse() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkTree() {
        Content content = this.getHyperLink("package-tree.html", "", this.treeLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }
}

