/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.AbstractPackageIndexWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map<String, List<PackageDoc>> groupPackageMap;
    private List<String> groupList;

    public PackageIndexWriter(ConfigurationImpl configurationImpl, String string) throws IOException {
        super(configurationImpl, string);
        this.root = configurationImpl.root;
        this.groupPackageMap = configurationImpl.group.groupPackages(this.packages);
        this.groupList = configurationImpl.group.getGroupList();
    }

    public static void generate(ConfigurationImpl configurationImpl) {
        String string = "overview-summary.html";
        try {
            PackageIndexWriter packageIndexWriter = new PackageIndexWriter(configurationImpl, string);
            packageIndexWriter.buildPackageIndexFile("doclet.Window_Overview_Summary", true);
            packageIndexWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    @Override
    protected void addIndex(Content content) {
        for (int i = 0; i < this.groupList.size(); ++i) {
            String string = this.groupList.get(i);
            List<PackageDoc> list = this.groupPackageMap.get(string);
            if (list == null || list.size() <= 0) continue;
            this.addIndexContents(list.toArray(new PackageDoc[list.size()]), string, this.configuration.getText("doclet.Member_Table_Summary", string, this.configuration.getText("doclet.packages")), content);
        }
    }

    @Override
    protected void addPackagesList(PackageDoc[] packageDocArray, String string, String string2, Content content) {
        HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.overviewSummary, 0, 3, 0, string2, this.getTableCaption(string));
        ((Content)htmlTree).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
        this.addPackagesList(packageDocArray, htmlTree2);
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree3 = HtmlTree.DIV(HtmlStyle.contentContainer, htmlTree);
        content.addContent(htmlTree3);
    }

    protected void addPackagesList(PackageDoc[] packageDocArray, Content content) {
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (packageDocArray[i] == null || packageDocArray[i].name().length() <= 0 || this.configuration.nodeprecated && Util.isDeprecated(packageDocArray[i])) continue;
            Content content2 = this.getPackageLink(packageDocArray[i], this.getPackageName(packageDocArray[i]));
            HtmlTree htmlTree = HtmlTree.TD(HtmlStyle.colFirst, content2);
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TD);
            htmlTree2.addStyle(HtmlStyle.colLast);
            this.addSummaryComment(packageDocArray[i], htmlTree2);
            HtmlTree htmlTree3 = HtmlTree.TR(htmlTree);
            htmlTree3.addContent(htmlTree2);
            if (i % 2 == 0) {
                htmlTree3.addStyle(HtmlStyle.altColor);
            } else {
                htmlTree3.addStyle(HtmlStyle.rowColor);
            }
            content.addContent(htmlTree3);
        }
    }

    @Override
    protected void addOverviewHeader(Content content) {
        if (this.root.inlineTags().length > 0) {
            HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.subTitle);
            this.addSummaryComment(this.root, htmlTree);
            HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.header, htmlTree);
            Content content2 = this.seeLabel;
            content2.addContent(" ");
            HtmlTree htmlTree3 = HtmlTree.P(content2);
            Content content3 = this.getHyperLink("", "overview_description", this.descriptionLabel, "", "");
            ((Content)htmlTree3).addContent(content3);
            ((Content)htmlTree2).addContent(htmlTree3);
            content.addContent(htmlTree2);
        }
    }

    protected void addOverviewComment(Content content) {
        if (this.root.inlineTags().length > 0) {
            content.addContent(this.getMarkerAnchor("overview_description"));
            HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.subTitle);
            this.addInlineComment(this.root, htmlTree);
            content.addContent(htmlTree);
        }
    }

    @Override
    protected void addOverview(Content content) throws IOException {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.footer);
        this.addOverviewComment(htmlTree);
        this.addTagsInfo(this.root, htmlTree);
        content.addContent(htmlTree);
    }

    @Override
    protected void addNavigationBarHeader(Content content) {
        this.addTop(content);
        this.addNavLinks(true, content);
        this.addConfigurationTitle(content);
    }

    @Override
    protected void addNavigationBarFooter(Content content) {
        this.addNavLinks(false, content);
        this.addBottom(content);
    }
}

