/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allclasses-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allclasses-noframe.html";
    protected IndexBuilder indexbuilder;
    final HtmlTree BR = new HtmlTree(HtmlTag.BR);

    public AllClassesFrameWriter(ConfigurationImpl configurationImpl, String string, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, string);
        this.indexbuilder = indexBuilder;
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        String string = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllClassesFrameWriter allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, string, indexBuilder);
            allClassesFrameWriter.buildAllClassesFile(true);
            allClassesFrameWriter.close();
            string = OUTPUT_FILE_NAME_NOFRAMES;
            allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, string, indexBuilder);
            allClassesFrameWriter.buildAllClassesFile(false);
            allClassesFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void buildAllClassesFile(boolean bl) throws IOException {
        String string = this.configuration.getText("doclet.All_Classes");
        HtmlTree htmlTree = this.getBody(false, this.getWindowTitle(string));
        HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, this.allclassesLabel);
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.UL);
        this.addAllClasses(htmlTree3, bl);
        HtmlTree htmlTree4 = HtmlTree.DIV(HtmlStyle.indexContainer, htmlTree3);
        ((Content)htmlTree).addContent(htmlTree4);
        this.printHtmlDocument(null, false, htmlTree);
    }

    protected void addAllClasses(Content content, boolean bl) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character c = (Character)this.indexbuilder.elements()[i];
            this.addContents(this.indexbuilder.getMemberList(c), bl, content);
        }
    }

    protected void addContents(List<Doc> list, boolean bl, Content content) {
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = (ClassDoc)list.get(i);
            if (!Util.isCoreClass(classDoc)) continue;
            String string = this.italicsClassName(classDoc, false);
            RawHtml rawHtml = bl ? new RawHtml(this.getLink(new LinkInfoImpl(1, classDoc, string, "classFrame"))) : new RawHtml(this.getLink(new LinkInfoImpl(classDoc, string)));
            HtmlTree htmlTree = HtmlTree.LI(rawHtml);
            content.addContent(htmlTree);
        }
    }
}

