/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.sun.tools.doclets.formats.html.ClassWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractMemberWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public final boolean nodepr;

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        this.writer = subWriterHolderWriter;
        this.nodepr = this.configuration().nodeprecated;
        this.classdoc = classDoc;
    }

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter) {
        this(subWriterHolderWriter, null);
    }

    public abstract void addSummaryLabel(Content var1);

    public abstract String getTableSummary();

    public abstract String getCaption();

    public abstract String[] getSummaryTableHeader(ProgramElementDoc var1);

    public abstract void addInheritedSummaryLabel(ClassDoc var1, Content var2);

    public abstract void addSummaryAnchor(ClassDoc var1, Content var2);

    public abstract void addInheritedSummaryAnchor(ClassDoc var1, Content var2);

    protected abstract void addSummaryType(ProgramElementDoc var1, Content var2);

    protected void addSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc, Content content) {
        this.addSummaryLink(3, classDoc, programElementDoc, content);
    }

    protected abstract void addSummaryLink(int var1, ClassDoc var2, ProgramElementDoc var3, Content var4);

    protected abstract void addInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2, Content var3);

    protected abstract Content getDeprecatedLink(ProgramElementDoc var1);

    protected abstract Content getNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void addNavDetailLink(boolean var1, Content var2);

    protected void print(String string) {
        this.writer.print(string);
        this.writer.displayLength += string.length();
    }

    protected void print(char c) {
        this.writer.print(c);
        ++this.writer.displayLength;
    }

    protected void strong(String string) {
        this.writer.strong(string);
        this.writer.displayLength += string.length();
    }

    protected void addName(String string, Content content) {
        content.addContent(string);
        this.writer.displayLength += string.length();
    }

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String typeString(MemberDoc memberDoc) {
        String string = "";
        if (memberDoc instanceof MethodDoc) {
            string = ((MethodDoc)memberDoc).returnType().toString();
        } else if (memberDoc instanceof FieldDoc) {
            string = ((FieldDoc)memberDoc).type().toString();
        }
        return string;
    }

    protected void addModifiers(MemberDoc memberDoc, Content content) {
        String string = this.modifierString(memberDoc);
        if ((memberDoc.isField() || memberDoc.isMethod()) && this.writer instanceof ClassWriterImpl && ((ClassWriterImpl)this.writer).getClassDoc().isInterface()) {
            string = Util.replaceText(string, "public", "").trim();
        }
        if (string.length() > 0) {
            content.addContent(string);
            content.addContent(this.writer.getSpace());
        }
    }

    protected String makeSpace(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected void addModifierAndType(ProgramElementDoc programElementDoc, Type type, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.CODE);
        this.addModifier(programElementDoc, htmlTree);
        if (type == null) {
            if (programElementDoc.isClass()) {
                htmlTree.addContent("class");
            } else {
                htmlTree.addContent("interface");
            }
            htmlTree.addContent(this.writer.getSpace());
        } else if (programElementDoc instanceof ExecutableMemberDoc && ((ExecutableMemberDoc)programElementDoc).typeParameters().length > 0) {
            int n = ((AbstractExecutableMemberWriter)this).addTypeParameters((ExecutableMemberDoc)programElementDoc, htmlTree);
            if (n > 10) {
                htmlTree.addContent(new HtmlTree(HtmlTag.BR));
            }
            htmlTree.addContent(new RawHtml(this.writer.getLink(new LinkInfoImpl(17, type))));
        } else {
            htmlTree.addContent(new RawHtml(this.writer.getLink(new LinkInfoImpl(17, type))));
        }
        content.addContent(htmlTree);
    }

    private void printModifier(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isProtected()) {
            this.print("protected ");
        } else if (programElementDoc.isPrivate()) {
            this.print("private ");
        } else if (!programElementDoc.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (programElementDoc.isMethod() && ((MethodDoc)programElementDoc).isAbstract()) {
            this.print("abstract ");
        }
        if (programElementDoc.isStatic()) {
            this.print("static");
        }
    }

    private void addModifier(ProgramElementDoc programElementDoc, Content content) {
        if (programElementDoc.isProtected()) {
            content.addContent("protected ");
        } else if (programElementDoc.isPrivate()) {
            content.addContent("private ");
        } else if (!programElementDoc.isPublic()) {
            content.addContent(this.configuration().getText("doclet.Package_private"));
            content.addContent(" ");
        }
        if (programElementDoc.isMethod() && ((MethodDoc)programElementDoc).isAbstract()) {
            content.addContent("abstract ");
        }
        if (programElementDoc.isStatic()) {
            content.addContent("static ");
        }
    }

    protected void addDeprecatedInfo(ProgramElementDoc programElementDoc, Content content) {
        String string = new DeprecatedTaglet().getTagletOutput(programElementDoc, this.writer.getTagletWriterInstance(false)).toString().trim();
        if (!string.isEmpty()) {
            RawHtml rawHtml = new RawHtml(string);
            HtmlTree htmlTree = HtmlTree.DIV(HtmlStyle.block, rawHtml);
            content.addContent(htmlTree);
        }
    }

    protected void addComment(ProgramElementDoc programElementDoc, Content content) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.addInlineComment(programElementDoc, content);
        }
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected Content getHead(MemberDoc memberDoc) {
        RawHtml rawHtml = new RawHtml(memberDoc.name());
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, rawHtml);
        return htmlTree;
    }

    protected boolean isInherited(ProgramElementDoc programElementDoc) {
        return !programElementDoc.isPrivate() && (!programElementDoc.isPackagePrivate() || programElementDoc.containingPackage().equals(this.classdoc.containingPackage()));
    }

    protected void addDeprecatedAPI(List<Doc> list, String string, String string2, String[] stringArray, Content content) {
        if (list.size() > 0) {
            Object object;
            HtmlTree htmlTree = HtmlTree.TABLE(0, 3, 0, string2, this.writer.getTableCaption(this.configuration().getText(string)));
            ((Content)htmlTree).addContent(this.writer.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < list.size(); ++i) {
                object = (ProgramElementDoc)list.get(i);
                HtmlTree htmlTree3 = HtmlTree.TD(HtmlStyle.colOne, this.getDeprecatedLink((ProgramElementDoc)object));
                if (object.tags("deprecated").length > 0) {
                    this.writer.addInlineDeprecatedComment((Doc)object, object.tags("deprecated")[0], htmlTree3);
                }
                HtmlTree htmlTree4 = HtmlTree.TR(htmlTree3);
                if (i % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                ((Content)htmlTree2).addContent(htmlTree4);
            }
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree5 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
            object = HtmlTree.UL(HtmlStyle.blockList, htmlTree5);
            content.addContent((Content)object);
        }
    }

    protected void addUseInfo(List<? extends ProgramElementDoc> list, String string, String string2, Content content) {
        if (list == null) {
            return;
        }
        List<? extends ProgramElementDoc> list2 = list;
        boolean bl = false;
        if (list2.size() > 0) {
            HtmlTree htmlTree = HtmlTree.TABLE(0, 3, 0, string2, this.writer.getTableCaption(string));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            Iterator<? extends ProgramElementDoc> iterator = list2.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ProgramElementDoc programElementDoc = iterator.next();
                ClassDoc classDoc = programElementDoc.containingClass();
                if (!bl) {
                    ((Content)htmlTree).addContent(this.writer.getSummaryTableHeader(this.getSummaryTableHeader(programElementDoc), "col"));
                    bl = true;
                }
                HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TR);
                if (n % 2 == 0) {
                    htmlTree3.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree3.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree htmlTree4 = new HtmlTree(HtmlTag.TD);
                htmlTree4.addStyle(HtmlStyle.colFirst);
                this.writer.addSummaryType(this, programElementDoc, htmlTree4);
                htmlTree3.addContent(htmlTree4);
                HtmlTree htmlTree5 = new HtmlTree(HtmlTag.TD);
                htmlTree5.addStyle(HtmlStyle.colLast);
                if (classDoc != null && !(programElementDoc instanceof ConstructorDoc) && !(programElementDoc instanceof ClassDoc)) {
                    HtmlTree htmlTree6 = new HtmlTree(HtmlTag.SPAN);
                    htmlTree6.addStyle(HtmlStyle.strong);
                    htmlTree6.addContent(classDoc.name() + ".");
                    htmlTree5.addContent(htmlTree6);
                }
                this.addSummaryLink(programElementDoc instanceof ClassDoc ? 4 : 3, classDoc, programElementDoc, htmlTree5);
                this.writer.addSummaryLinkComment(this, programElementDoc, htmlTree5);
                htmlTree3.addContent(htmlTree5);
                ((Content)htmlTree2).addContent(htmlTree3);
                ++n;
            }
            ((Content)htmlTree).addContent(htmlTree2);
            content.addContent(htmlTree);
        }
    }

    protected void addNavDetailLink(List<?> list, Content content) {
        this.addNavDetailLink(list.size() > 0, content);
    }

    protected void addNavSummaryLink(List<?> list, VisibleMemberMap visibleMemberMap, Content content) {
        if (list.size() > 0) {
            content.addContent(this.getNavSummaryLink(null, true));
            return;
        }
        for (ClassDoc classDoc = this.classdoc.superclass(); classDoc != null; classDoc = classDoc.superclass()) {
            List<ProgramElementDoc> list2 = visibleMemberMap.getMembersFor(classDoc);
            if (list2.size() <= 0) continue;
            content.addContent(this.getNavSummaryLink(classDoc, true));
            return;
        }
        content.addContent(this.getNavSummaryLink(null, false));
    }

    protected void serialWarning(SourcePosition sourcePosition, String string, String string2, String string3) {
        if (this.configuration().serialwarn) {
            ConfigurationImpl.getInstance().getDocletSpecificMsg().warning(sourcePosition, string, string2, string3);
        }
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] programElementDocArray) {
        return this.nodepr ? Util.excludeDeprecatedMembers(programElementDocArray) : programElementDocArray;
    }

    public ConfigurationImpl configuration() {
        return this.writer.configuration;
    }

    public void addMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, Tag[] tagArray, Content content, int n) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TD);
        htmlTree.addStyle(HtmlStyle.colFirst);
        this.writer.addSummaryType(this, programElementDoc, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TD);
        this.setSummaryColumnStyle(htmlTree2);
        this.addSummaryLink(classDoc, programElementDoc, htmlTree2);
        this.writer.addSummaryLinkComment(this, programElementDoc, tagArray, htmlTree2);
        HtmlTree htmlTree3 = HtmlTree.TR(htmlTree);
        htmlTree3.addContent(htmlTree2);
        if (n % 2 == 0) {
            htmlTree3.addStyle(HtmlStyle.altColor);
        } else {
            htmlTree3.addStyle(HtmlStyle.rowColor);
        }
        content.addContent(htmlTree3);
    }

    public void setSummaryColumnStyle(HtmlTree htmlTree) {
        htmlTree.addStyle(HtmlStyle.colLast);
    }

    public void addInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, boolean bl, boolean bl2, Content content) {
        this.writer.addInheritedMemberSummary(this, classDoc, programElementDoc, bl, content);
    }

    public Content getInheritedSummaryHeader(ClassDoc classDoc) {
        Content content = this.writer.getMemberTreeHeader();
        this.writer.addInheritedSummaryHeader(this, classDoc, content);
        return content;
    }

    public Content getInheritedSummaryLinksTree() {
        return new HtmlTree(HtmlTag.CODE);
    }

    public Content getSummaryTableTree(ClassDoc classDoc) {
        return this.writer.getSummaryTableTree(this, classDoc);
    }

    public Content getMemberTree(Content content) {
        return this.writer.getMemberTree(content);
    }

    public Content getMemberTree(Content content, boolean bl) {
        if (bl) {
            return HtmlTree.UL(HtmlStyle.blockListLast, content);
        }
        return HtmlTree.UL(HtmlStyle.blockList, content);
    }
}

