/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.comp;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.apt.comp.AnnotationProcessingError;
import com.sun.tools.apt.comp.BootstrapAPF;
import com.sun.tools.apt.comp.UsageMessageNeededException;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.apt.AnnotationProcessorEnvironmentImpl;
import com.sun.tools.apt.mirror.apt.FilerImpl;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import sun.misc.Service;

public class Apt
extends ListBuffer<Env<AttrContext>> {
    Set<String> genSourceFileNames = new LinkedHashSet<String>();
    Set<String> genClassFileNames = new LinkedHashSet<String>();
    AptEnv aptenv;
    private Context context;
    protected static final Context.Key<Apt> aptKey = new Context.Key();

    public Set<String> getSourceFileNames() {
        return this.genSourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.genClassFileNames;
    }

    public static Apt instance(Context context) {
        Apt apt2 = context.get(aptKey);
        if (apt2 == null) {
            apt2 = new Apt(context);
        }
        return apt2;
    }

    protected Apt(Context context) {
        this.context = context;
        context.put(aptKey, this);
        this.aptenv = AptEnv.instance(context);
    }

    Set<String> computeAnnotationSet(Collection<Symbol.ClassSymbol> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Symbol.ClassSymbol classSymbol : collection) {
            this.computeAnnotationSet(classSymbol, hashSet);
        }
        return hashSet;
    }

    void computeAnnotationSet(Symbol symbol, Set<String> set) {
        if (symbol != null) {
            if (symbol.getAnnotationMirrors() != null) {
                for (Attribute.Compound object : symbol.getAnnotationMirrors()) {
                    set.add(object.type.tsym.toString());
                }
            }
            if (symbol instanceof Symbol.MethodSymbol) {
                for (Symbol symbol2 : ((Symbol.MethodSymbol)symbol).params()) {
                    this.computeAnnotationSet(symbol2, set);
                }
            }
            if (symbol.members() != null) {
                Object object = symbol.members().elems;
                while (object != null) {
                    this.computeAnnotationSet(((Scope.Entry)object).sym, set);
                    object = ((Scope.Entry)object).sibling;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void main(List<JCTree.JCCompilationUnit> list, ListBuffer<Symbol.ClassSymbol> listBuffer, Map<String, String> map, ClassLoader classLoader, AnnotationProcessorFactory annotationProcessorFactory, Set<Class<? extends AnnotationProcessorFactory>> set) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Bark bark = Bark.instance(this.context);
        PrintWriter printWriter = bark.warnWriter;
        Options options = Options.instance(this.context);
        LinkedHashSet<TypeDeclaration> linkedHashSet = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<TypeDeclaration> linkedHashSet2 = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
        Set set2 = Collections.emptySet();
        LinkedHashSet linkedHashSet4 = new LinkedHashSet();
        AptTreeScanner aptTreeScanner = new AptTreeScanner();
        for (JCTree iterator2 : list) {
            iterator2.accept(aptTreeScanner);
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.specifiedDeclCollection) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)((Object)linkedHashMap));
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.declCollection) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet2.add((TypeDeclaration)((Object)linkedHashMap));
        }
        linkedHashSet3.addAll(aptTreeScanner.getAnnotationSet());
        for (Symbol.ClassSymbol classSymbol : listBuffer) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)((Object)linkedHashMap));
            linkedHashSet2.add((TypeDeclaration)((Object)linkedHashMap));
            this.computeAnnotationSet(classSymbol, linkedHashSet3);
        }
        if (options.get("-XListAnnotationTypes") != null) {
            printWriter.println("Set of annotations found:" + new TreeSet(linkedHashSet3).toString());
        }
        AnnotationProcessorEnvironmentImpl annotationProcessorEnvironmentImpl = new AnnotationProcessorEnvironmentImpl(linkedHashSet, linkedHashSet2, map, this.context);
        if (options.get("-XListDeclarations") != null) {
            printWriter.println("Set of Specified Declarations:" + linkedHashSet);
            printWriter.println("Set of Included Declarations: " + linkedHashSet2);
        }
        if (options.get("-print") != null) {
            if (linkedHashSet.size() == 0) {
                throw new UsageMessageNeededException();
            }
            AnnotationProcessor annotationProcessor = new BootstrapAPF().getProcessorFor(new HashSet<AnnotationTypeDeclaration>(), annotationProcessorEnvironmentImpl);
            annotationProcessor.process();
        } else {
            Object object;
            Object object2;
            void var17_29;
            Object object3;
            Object var17_25 = null;
            linkedHashMap = new LinkedList();
            Set<Object> set3 = options.get("-factory");
            if (annotationProcessorFactory != null) {
                linkedHashMap.add(annotationProcessorFactory);
                Iterator iterator = linkedHashMap.iterator();
            } else if (set3 != null) {
                try {
                    object3 = (AnnotationProcessorFactory)classLoader.loadClass((String)((Object)set3)).newInstance();
                    linkedHashMap.add(object3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bark.aptWarning("FactoryNotFound", set3);
                }
                catch (ClassCastException classCastException) {
                    bark.aptWarning("FactoryWrongType", set3);
                }
                catch (Exception exception) {
                    bark.aptWarning("FactoryCantInstantiate", set3);
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
                Iterator iterator = linkedHashMap.iterator();
            } else {
                object3 = Service.providers(AnnotationProcessorFactory.class, (ClassLoader)classLoader);
                Iterator iterator = object3;
            }
            linkedHashMap = new LinkedHashMap<Object, Object>();
            if (!var17_29.hasNext() && set.size() == 0) {
                if (linkedHashSet3.size() > 0) {
                    bark.aptWarning("NoAnnotationProcessors", new Object[0]);
                }
                if (linkedHashSet.size() == 0) {
                    throw new UsageMessageNeededException();
                }
                return;
            }
            if (linkedHashSet3.size() == 0) {
                linkedHashSet3.add("");
            }
            set3 = new HashSet();
            set3.add("");
            set3 = Collections.unmodifiableSet(set3);
            while (var17_29.hasNext()) {
                object3 = var17_29.next();
                try {
                    HashSet<String> hashSet = new HashSet<String>();
                    object2 = (AnnotationProcessorFactory)object3;
                    object = object2.supportedAnnotationTypes();
                    LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
                    Object object4 = object.iterator();
                    while (object4.hasNext()) {
                        String string = object4.next();
                        linkedList.add(this.importStringToPattern(string));
                    }
                    block22: for (String string : linkedHashSet3) {
                        for (Pattern pattern : linkedList) {
                            if (!pattern.matcher(string).matches()) continue;
                            hashSet.add(string);
                            continue block22;
                        }
                    }
                    linkedHashSet3.removeAll(hashSet);
                    if (options.get("-XPrintFactoryInfo") != null) {
                        printWriter.println("Factory " + object2.getClass().getName() + " matches " + (hashSet.size() == 0 ? "nothing." : hashSet));
                    }
                    if (hashSet.size() > 0) {
                        object4 = new HashSet();
                        if (!hashSet.equals(set3)) {
                            for (Object object5 : hashSet) {
                                TypeDeclaration typeDeclaration = this.aptenv.declMaker.getTypeDeclaration((String)object5);
                                if (typeDeclaration == null) {
                                    bark.aptError("DeclarationCreation", object5);
                                    continue;
                                }
                                try {
                                    AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)typeDeclaration;
                                    object4.add(annotationTypeDeclaration);
                                }
                                catch (ClassCastException classCastException) {
                                    bark.aptError("BadDeclaration", object5);
                                }
                            }
                        }
                        linkedHashSet4.add(object2.getClass());
                        set.add(object2.getClass());
                        linkedHashMap.put(object2, object4);
                    } else if (set.contains(object2.getClass())) {
                        linkedHashSet4.add(object2.getClass());
                        linkedHashMap.put(object2, set2);
                    }
                    if (linkedHashSet3.size() != 0) continue;
                    break;
                }
                catch (ClassCastException classCastException) {
                    bark.aptWarning("BadFactory", classCastException);
                }
            }
            linkedHashSet3.remove("");
            set3 = new LinkedHashSet<Class<? extends AnnotationProcessorFactory>>(set);
            set3.removeAll(linkedHashSet4);
            for (Class clazz : set3) {
                try {
                    object2 = (AnnotationProcessorFactory)clazz.newInstance();
                    linkedHashMap.put(object2, set2);
                }
                catch (Exception exception) {
                    bark.aptWarning("FactoryCantInstantiate", clazz.getName());
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
            }
            if (linkedHashSet3.size() > 0) {
                bark.aptWarning("AnnotationsWithoutProcessors", linkedHashSet3);
            }
            set3 = new LinkedHashSet<Object>();
            if (linkedHashSet.size() == 0 && linkedHashMap.keySet().size() == 0) {
                throw new UsageMessageNeededException();
            }
            try {
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    object2 = (AnnotationProcessorFactory)entry.getKey();
                    object = object2.getProcessorFor((Set)entry.getValue(), annotationProcessorEnvironmentImpl);
                    if (object != null) {
                        set3.add(object);
                        continue;
                    }
                    bark.aptWarning("NullProcessor", object2.getClass().getName());
                }
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            object3 = new LinkedList();
            ((LinkedList)object3).addAll(set3);
            AnnotationProcessor annotationProcessor = AnnotationProcessors.getCompositeAnnotationProcessor((Collection<AnnotationProcessor>)object3);
            try {
                annotationProcessor.process();
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            annotationProcessorEnvironmentImpl.roundComplete();
            object2 = (FilerImpl)annotationProcessorEnvironmentImpl.getFiler();
            this.genSourceFileNames = ((FilerImpl)object2).getSourceFileNames();
            this.genClassFileNames = ((FilerImpl)object2).getClassFileNames();
            ((FilerImpl)object2).flush();
        }
    }

    Pattern importStringToPattern(String string) {
        if (JavacProcessingEnvironment.isValidImportString(string)) {
            return JavacProcessingEnvironment.validImportStringToPattern(string);
        }
        Bark bark = Bark.instance(this.context);
        bark.aptWarning("MalformedSupportedString", string);
        return JavacProcessingEnvironment.noMatches;
    }

    static class AptTreeScanner
    extends TreeScanner {
        private Set<String> annotationSet = new LinkedHashSet<String>();
        private Collection<Symbol.ClassSymbol> specifiedDeclCollection = new LinkedHashSet<Symbol.ClassSymbol>();
        private Collection<Symbol.ClassSymbol> declCollection = new LinkedHashSet<Symbol.ClassSymbol>();

        public Set<String> getAnnotationSet() {
            return this.annotationSet;
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
            super.visitTopLevel(jCCompilationUnit);
            for (JCTree jCTree : jCCompilationUnit.defs) {
                if (!(jCTree instanceof JCTree.JCClassDecl)) continue;
                this.specifiedDeclCollection.add(((JCTree.JCClassDecl)jCTree).sym);
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            super.visitClassDef(jCClassDecl);
            this.declCollection.add(jCClassDecl.sym);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            super.visitMethodDef(jCMethodDecl);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            super.visitAnnotation(jCAnnotation);
            this.annotationSet.add(jCAnnotation.type.tsym.toString());
        }
    }
}

