/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.List;

public class ParamCriterion
implements Criterion {
    private final String methodName;
    private final Integer paramPos;

    public ParamCriterion(String methodName, Integer pos) {
        this.methodName = methodName.substring(0, methodName.indexOf(")") + 1);
        this.paramPos = pos;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (leaf instanceof VariableTree) {
            List<? extends VariableTree> params;
            Tree parent = path.getParentPath().getLeaf();
            switch (parent.getKind()) {
                case METHOD: {
                    params = ((MethodTree)parent).getParameters();
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    params = ((LambdaExpressionTree)parent).getParameters();
                    break;
                }
                default: {
                    params = null;
                }
            }
            return params != null && params.size() > this.paramPos && params.get(this.paramPos).equals(leaf);
        }
        return this.isSatisfiedBy(path.getParentPath());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.PARAM;
    }

    public String toString() {
        return "ParamCriterion for method: " + this.methodName + " at position: " + this.paramPos;
    }
}

