/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.MemberReferenceScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class MemberReferenceCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public MemberReferenceCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (leaf.getKind() == Tree.Kind.MEMBER_REFERENCE) {
            int indexInClass;
            int indexInSource = MemberReferenceScanner.indexOfMemberReferenceTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = MemberReferenceScanner.getMemberReferenceIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        return b;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_REFERENCE;
    }

    public String toString() {
        return "MemberReferenceCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

