/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jps;

import java.io.PrintStream;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.HostIdentifier;

public class Arguments {
    private static final boolean debug = Boolean.getBoolean("jps.debug");
    private static final boolean printStackTrace = Boolean.getBoolean("jps.printStackTrace");
    private boolean help;
    private boolean quiet;
    private boolean longPaths;
    private boolean vmArgs;
    private boolean vmFlags;
    private boolean mainArgs;
    private String hostname;
    private HostIdentifier hostId;

    public static void printUsage(PrintStream printStream) {
        printStream.println("usage: jps [-help]");
        printStream.println("       jps [-q] [-mlvV] [<hostid>]");
        printStream.println();
        printStream.println("Definitions:");
        printStream.println("    <hostid>:      <hostname>[:<port>]");
    }

    public Arguments(String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        if (stringArray.length == 1 && (stringArray[0].compareTo("-?") == 0 || stringArray[0].compareTo("-help") == 0)) {
            this.help = true;
            return;
        }
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string = stringArray[n];
            if (string.compareTo("-q") == 0) {
                this.quiet = true;
                continue;
            }
            if (string.startsWith("-")) {
                block13: for (int i = 1; i < string.length(); ++i) {
                    switch (string.charAt(i)) {
                        case 'm': {
                            this.mainArgs = true;
                            continue block13;
                        }
                        case 'l': {
                            this.longPaths = true;
                            continue block13;
                        }
                        case 'v': {
                            this.vmArgs = true;
                            continue block13;
                        }
                        case 'V': {
                            this.vmFlags = true;
                            continue block13;
                        }
                        default: {
                            throw new IllegalArgumentException("illegal argument: " + stringArray[n]);
                        }
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("illegal argument: " + stringArray[n]);
        }
        switch (stringArray.length - n) {
            case 0: {
                this.hostname = null;
                break;
            }
            case 1: {
                this.hostname = stringArray[stringArray.length - 1];
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument count");
            }
        }
        try {
            this.hostId = new HostIdentifier(this.hostname);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Malformed Host Identifier: " + this.hostname);
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    public boolean isDebug() {
        return debug;
    }

    public boolean printStackTrace() {
        return printStackTrace;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean showLongPaths() {
        return this.longPaths;
    }

    public boolean showVmArgs() {
        return this.vmArgs;
    }

    public boolean showVmFlags() {
        return this.vmFlags;
    }

    public boolean showMainArgs() {
        return this.mainArgs;
    }

    public String hostname() {
        return this.hostname;
    }

    public HostIdentifier hostId() {
        return this.hostId;
    }
}

