/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Timestamp;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Encoder;
import sun.security.tools.JarBASE64Encoder;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.KeyTool;
import sun.security.tools.SignatureFile;
import sun.security.tools.TimestampedSigner;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ManifestDigester;
import sun.security.util.Password;
import sun.security.util.PathList;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.NetscapeCertTypeExtension;

public class JarSigner {
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.JarSignerResources");
    private static final Collator collator = Collator.getInstance();
    private static final String META_INF = "META-INF/";
    private static final Class[] PARAM_STRING;
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final long SIX_MONTHS = 15552000000L;
    static final String VERSION = "1.0";
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    static final int NOT_ALIAS = 4;
    static final int SIGNED_BY_ALIAS = 8;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store;
    String keystore;
    boolean nullStream = false;
    boolean token = false;
    String jarfile;
    String alias;
    List<String> ckaliases = new ArrayList<String>();
    char[] storepass;
    boolean protectedPath;
    String storetype;
    String providerName;
    Vector<String> providers = null;
    HashMap<String, String> providerArgs = new HashMap();
    char[] keypass;
    String sigfile;
    String sigalg;
    String digestalg = "SHA-256";
    String signedjar;
    String tsaUrl;
    String tsaAlias;
    String altCertChain;
    boolean verify = false;
    String verbose = null;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    boolean strict = false;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private byte[] buffer = new byte[8192];
    private ContentSigner signingMechanism = null;
    private String altSignerClass = null;
    private String altSignerClasspath = null;
    private ZipFile zipFile = null;
    private boolean hasExpiringCert = false;
    private boolean noTimestamp = false;
    private Date expireDate = new Date(0L);
    private boolean hasExpiredCert = false;
    private boolean notYetValidCert = false;
    private boolean chainNotValidated = false;
    private boolean notSignedByAlias = false;
    private boolean aliasNotInStore = false;
    private boolean hasUnsignedEntry = false;
    private boolean badKeyUsage = false;
    private boolean badExtendedKeyUsage = false;
    private boolean badNetscapeCertType = false;
    CertificateFactory certificateFactory;
    CertPathValidator validator;
    PKIXParameters pkixParameters;
    private static MessageFormat validityTimeForm;
    private static MessageFormat notYetTimeForm;
    private static MessageFormat expiredTimeForm;
    private static MessageFormat expiringTimeForm;
    private static MessageFormat signTimeForm;
    private Map<CodeSigner, Integer> cacheForInKS = new IdentityHashMap<CodeSigner, Integer>();
    Hashtable<Certificate, String> storeHash = new Hashtable();
    Map<CodeSigner, String> cacheForSignerInfo = new IdentityHashMap<CodeSigner, String>();

    public static void main(String[] stringArray) throws Exception {
        JarSigner jarSigner = new JarSigner();
        jarSigner.run(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] stringArray) {
        block24: {
            try {
                this.parseArgs(stringArray);
                if (this.providers != null) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Enumeration<String> enumeration = this.providers.elements();
                    while (enumeration.hasMoreElements()) {
                        Object object;
                        Object obj;
                        String string = enumeration.nextElement();
                        Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                        String string2 = this.providerArgs.get(string);
                        if (string2 == null) {
                            obj = clazz.newInstance();
                        } else {
                            object = clazz.getConstructor(PARAM_STRING);
                            obj = ((Constructor)object).newInstance(string2);
                        }
                        if (!(obj instanceof Provider)) {
                            object = new MessageFormat(rb.getString("provName.not.a.provider"));
                            Object[] objectArray = new Object[]{string};
                            throw new Exception(((Format)object).format(objectArray));
                        }
                        Security.addProvider((Provider)obj);
                    }
                }
                if (this.verify) {
                    block23: {
                        try {
                            this.loadKeyStore(this.keystore, false);
                        }
                        catch (Exception exception) {
                            if (this.keystore == null && this.storepass == null) break block23;
                            System.out.println(rb.getString("jarsigner.error.") + exception.getMessage());
                            System.exit(1);
                        }
                    }
                    this.verifyJar(this.jarfile);
                    break block24;
                }
                this.loadKeyStore(this.keystore, true);
                this.getAliasInfo(this.alias);
                if (this.altSignerClass != null) {
                    this.signingMechanism = this.loadSigningMechanism(this.altSignerClass, this.altSignerClasspath);
                }
                this.signJar(this.jarfile, this.alias, stringArray);
            }
            catch (Exception exception) {
                System.out.println(rb.getString("jarsigner.error.") + exception);
                if (this.debug) {
                    exception.printStackTrace();
                }
                System.exit(1);
            }
            finally {
                if (this.keypass != null) {
                    Arrays.fill(this.keypass, ' ');
                    this.keypass = null;
                }
                if (this.storepass != null) {
                    Arrays.fill(this.storepass, ' ');
                    this.storepass = null;
                }
            }
        }
        if (this.strict) {
            int n = 0;
            if (this.chainNotValidated || this.hasExpiredCert || this.notYetValidCert) {
                n |= 4;
            }
            if (this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType) {
                n |= 8;
            }
            if (this.hasUnsignedEntry) {
                n |= 0x10;
            }
            if (this.notSignedByAlias || this.aliasNotInStore) {
                n |= 0x20;
            }
            if (n != 0) {
                System.exit(n);
            }
        }
    }

    void parseArgs(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 0) {
            JarSigner.fullusage();
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            String string = stringArray[n];
            String string2 = null;
            if (string.charAt(0) == '-' && (n2 = string.indexOf(58)) > 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            if (collator.compare(string, "-keystore") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.keystore = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-storepass") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.storepass = JarSigner.getPass(string2, stringArray[n]);
                continue;
            }
            if (collator.compare(string, "-storetype") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.storetype = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-providerName") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.providerName = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-provider") == 0 || collator.compare(string, "-providerClass") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(stringArray[n]);
                if (stringArray.length <= n + 1 || collator.compare(string = stringArray[n + 1], "-providerArg") != 0) continue;
                if (stringArray.length == n + 2) {
                    JarSigner.usageNoArg();
                }
                this.providerArgs.put(stringArray[n], stringArray[n + 2]);
                n += 2;
                continue;
            }
            if (collator.compare(string, "-protected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(string, "-certchain") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.altCertChain = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(string, "-keypass") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.keypass = JarSigner.getPass(string2, stringArray[n]);
                continue;
            }
            if (collator.compare(string, "-sigfile") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.sigfile = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-signedjar") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.signedjar = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-tsa") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.tsaUrl = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-tsacert") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.tsaAlias = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-altsigner") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.altSignerClass = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-altsignerpath") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.altSignerClasspath = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-sectionsonly") == 0) {
                this.signManifest = false;
                continue;
            }
            if (collator.compare(string, "-internalsf") == 0) {
                this.externalSF = false;
                continue;
            }
            if (collator.compare(string, "-verify") == 0) {
                this.verify = true;
                continue;
            }
            if (collator.compare(string, "-verbose") == 0) {
                this.verbose = string2 != null ? string2 : "all";
                continue;
            }
            if (collator.compare(string, "-sigalg") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.sigalg = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-digestalg") == 0) {
                if (++n == stringArray.length) {
                    JarSigner.usageNoArg();
                }
                this.digestalg = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-certs") == 0) {
                this.showcerts = true;
                continue;
            }
            if (collator.compare(string, "-strict") == 0) {
                this.strict = true;
                continue;
            }
            if (collator.compare(string, "-h") == 0 || collator.compare(string, "-help") == 0) {
                JarSigner.fullusage();
                continue;
            }
            if (!string.startsWith("-")) {
                if (this.jarfile == null) {
                    this.jarfile = string;
                    continue;
                }
                this.alias = string;
                this.ckaliases.add(this.alias);
                continue;
            }
            System.err.println(rb.getString("Illegal.option.") + string);
            JarSigner.usage();
        }
        if (this.verbose == null) {
            this.showcerts = false;
        }
        if (this.jarfile == null) {
            System.err.println(rb.getString("Please.specify.jarfile.name"));
            JarSigner.usage();
        }
        if (!this.verify && this.alias == null) {
            System.err.println(rb.getString("Please.specify.alias.name"));
            JarSigner.usage();
        }
        if (!this.verify && this.ckaliases.size() > 1) {
            System.err.println(rb.getString("Only.one.alias.can.be.specified"));
            JarSigner.usage();
        }
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        this.storetype = KeyStoreUtil.niceStoreTypeName(this.storetype);
        try {
            if (this.signedjar != null && new File(this.signedjar).getCanonicalPath().equals(new File(this.jarfile).getCanonicalPath())) {
                this.signedjar = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (P11KEYSTORE.equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.token = true;
            if (this.keystore == null) {
                this.keystore = NONE;
            }
        }
        if (NONE.equals(this.keystore)) {
            this.nullStream = true;
        }
        if (this.token && !this.nullStream) {
            System.err.println(MessageFormat.format(rb.getString(".keystore.must.be.NONE.if.storetype.is.{0}"), this.storetype));
            JarSigner.usage();
        }
        if (this.token && this.keypass != null) {
            System.err.println(MessageFormat.format(rb.getString(".keypass.can.not.be.specified.if.storetype.is.{0}"), this.storetype));
            JarSigner.usage();
        }
        if (this.protectedPath && (this.storepass != null || this.keypass != null)) {
            System.err.println(rb.getString("If.protected.is.specified.then.storepass.and.keypass.must.not.be.specified"));
            JarSigner.usage();
        }
        if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storepass != null || this.keypass != null)) {
            System.err.println(rb.getString("If.keystore.is.not.password.protected.then.storepass.and.keypass.must.not.be.specified"));
            JarSigner.usage();
        }
    }

    static char[] getPass(String string, String string2) {
        char[] cArray = KeyTool.getPassWithModifier((String)string, (String)string2);
        if (cArray != null) {
            return cArray;
        }
        JarSigner.usage();
        return null;
    }

    static void usageNoArg() {
        System.out.println(rb.getString("Option.lacks.argument"));
        JarSigner.usage();
    }

    static void usage() {
        System.out.println();
        System.out.println(rb.getString("Please.type.jarsigner.help.for.usage"));
        System.exit(1);
    }

    static void fullusage() {
        System.out.println(rb.getString("Usage.jarsigner.options.jar.file.alias"));
        System.out.println(rb.getString(".jarsigner.verify.options.jar.file.alias."));
        System.out.println();
        System.out.println(rb.getString(".keystore.url.keystore.location"));
        System.out.println();
        System.out.println(rb.getString(".storepass.password.password.for.keystore.integrity"));
        System.out.println();
        System.out.println(rb.getString(".storetype.type.keystore.type"));
        System.out.println();
        System.out.println(rb.getString(".keypass.password.password.for.private.key.if.different."));
        System.out.println();
        System.out.println(rb.getString(".certchain.file.name.of.alternative.certchain.file"));
        System.out.println();
        System.out.println(rb.getString(".sigfile.file.name.of.SF.DSA.file"));
        System.out.println();
        System.out.println(rb.getString(".signedjar.file.name.of.signed.JAR.file"));
        System.out.println();
        System.out.println(rb.getString(".digestalg.algorithm.name.of.digest.algorithm"));
        System.out.println();
        System.out.println(rb.getString(".sigalg.algorithm.name.of.signature.algorithm"));
        System.out.println();
        System.out.println(rb.getString(".verify.verify.a.signed.JAR.file"));
        System.out.println();
        System.out.println(rb.getString(".verbose.suboptions.verbose.output.when.signing.verifying."));
        System.out.println(rb.getString(".suboptions.can.be.all.grouped.or.summary"));
        System.out.println();
        System.out.println(rb.getString(".certs.display.certificates.when.verbose.and.verifying"));
        System.out.println();
        System.out.println(rb.getString(".tsa.url.location.of.the.Timestamping.Authority"));
        System.out.println();
        System.out.println(rb.getString(".tsacert.alias.public.key.certificate.for.Timestamping.Authority"));
        System.out.println();
        System.out.println(rb.getString(".altsigner.class.class.name.of.an.alternative.signing.mechanism"));
        System.out.println();
        System.out.println(rb.getString(".altsignerpath.pathlist.location.of.an.alternative.signing.mechanism"));
        System.out.println();
        System.out.println(rb.getString(".internalsf.include.the.SF.file.inside.the.signature.block"));
        System.out.println();
        System.out.println(rb.getString(".sectionsonly.don.t.compute.hash.of.entire.manifest"));
        System.out.println();
        System.out.println(rb.getString(".protected.keystore.has.protected.authentication.path"));
        System.out.println();
        System.out.println(rb.getString(".providerName.name.provider.name"));
        System.out.println();
        System.out.println(rb.getString(".providerClass.class.name.of.cryptographic.service.provider.s"));
        System.out.println(rb.getString(".providerArg.arg.master.class.file.and.constructor.argument"));
        System.out.println();
        System.out.println(rb.getString(".strict.treat.warnings.as.errors"));
        System.out.println();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyJar(String string) throws Exception {
        boolean bl = false;
        try (JarFile jarFile = null;){
            String string2;
            Object object;
            Object object2;
            Cloneable cloneable;
            jarFile = new JarFile(string, true);
            Vector<Cloneable> vector = new Vector<Cloneable>();
            byte[] byArray = new byte[8192];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                cloneable = enumeration.nextElement();
                vector.addElement(cloneable);
                object2 = null;
                try {
                    int n;
                    object2 = jarFile.getInputStream((ZipEntry)cloneable);
                    while ((n = ((InputStream)object2).read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                finally {
                    if (object2 == null) continue;
                    ((InputStream)object2).close();
                }
            }
            cloneable = jarFile.getManifest();
            object2 = new LinkedHashMap();
            if (cloneable != null) {
                if (this.verbose != null) {
                    System.out.println();
                }
                Enumeration enumeration2 = vector.elements();
                String object3 = rb.getString("6SPACE");
                while (enumeration2.hasMoreElements()) {
                    object = (JarEntry)enumeration2.nextElement();
                    string2 = ((ZipEntry)object).getName();
                    CodeSigner[] codeSignerArray = ((JarEntry)object).getCodeSigners();
                    boolean bl2 = codeSignerArray != null;
                    bl |= bl2;
                    this.hasUnsignedEntry |= !((ZipEntry)object).isDirectory() && !bl2 && !this.signatureRelated(string2);
                    int n = this.inKeyStore(codeSignerArray);
                    boolean bl3 = (n & 1) != 0;
                    boolean bl4 = (n & 2) != 0;
                    this.notSignedByAlias |= (n & 4) != 0;
                    if (this.keystore != null) {
                        this.aliasNotInStore |= bl2 && !bl3 && !bl4;
                    }
                    StringBuffer stringBuffer = null;
                    if (this.verbose != null) {
                        stringBuffer = new StringBuffer();
                        boolean bl5 = ((Manifest)cloneable).getAttributes(string2) != null || ((Manifest)cloneable).getAttributes("./" + string2) != null || ((Manifest)cloneable).getAttributes("/" + string2) != null;
                        stringBuffer.append((bl2 ? rb.getString("s") : rb.getString("SPACE")) + (bl5 ? rb.getString("m") : rb.getString("SPACE")) + (bl3 ? rb.getString("k") : rb.getString("SPACE")) + (bl4 ? rb.getString("i") : rb.getString("SPACE")) + ((n & 4) != 0 ? "X" : " ") + rb.getString("SPACE"));
                        stringBuffer.append("|");
                    }
                    if (bl2) {
                        if (this.showcerts) {
                            stringBuffer.append('\n');
                        }
                        for (CodeSigner codeSigner : codeSignerArray) {
                            String string3 = this.signerInfo(codeSigner, object3);
                            if (!this.showcerts) continue;
                            stringBuffer.append(string3);
                            stringBuffer.append('\n');
                        }
                    } else if (this.showcerts && !this.verbose.equals("all")) {
                        if (this.signatureRelated(string2)) {
                            stringBuffer.append("\n" + object3 + rb.getString(".Signature.related.entries.") + "\n\n");
                        } else {
                            stringBuffer.append("\n" + object3 + rb.getString(".Unsigned.entries.") + "\n\n");
                        }
                    }
                    if (this.verbose == null) continue;
                    String string4 = stringBuffer.toString();
                    if (this.signatureRelated(string2)) {
                        string4 = "-" + string4;
                    }
                    if (!object2.containsKey(string4)) {
                        object2.put(string4, new ArrayList());
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    String string5 = Long.toString(((ZipEntry)object).getSize());
                    for (int i = 6 - string5.length(); i > 0; --i) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(string5).append(' ').append(new Date(((ZipEntry)object).getTime()).toString());
                    stringBuffer2.append(' ').append(string2);
                    ((List)object2.get(string4)).add(stringBuffer2.toString());
                }
            }
            if (this.verbose != null) {
                for (Map.Entry entry : object2.entrySet()) {
                    Iterator iterator;
                    object = (List)entry.getValue();
                    string2 = (String)entry.getKey();
                    if (string2.charAt(0) == '-') {
                        string2 = string2.substring(1);
                    }
                    int n = string2.indexOf(124);
                    if (this.verbose.equals("all")) {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string6 = (String)iterator.next();
                            System.out.println(string2.substring(0, n) + string6);
                            System.out.printf(string2.substring(n + 1), new Object[0]);
                        }
                        continue;
                    }
                    if (this.verbose.equals("grouped")) {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string7 = (String)iterator.next();
                            System.out.println(string2.substring(0, n) + string7);
                        }
                    } else if (this.verbose.equals("summary")) {
                        System.out.print(string2.substring(0, n));
                        if (object.size() > 1) {
                            System.out.println((String)object.get(0) + " " + String.format(rb.getString(".and.d.more."), object.size() - 1));
                        } else {
                            System.out.println((String)object.get(0));
                        }
                    }
                    System.out.printf(string2.substring(n + 1), new Object[0]);
                }
                System.out.println();
                System.out.println(rb.getString(".s.signature.was.verified."));
                System.out.println(rb.getString(".m.entry.is.listed.in.manifest"));
                System.out.println(rb.getString(".k.at.least.one.certificate.was.found.in.keystore"));
                System.out.println(rb.getString(".i.at.least.one.certificate.was.found.in.identity.scope"));
                if (this.ckaliases.size() > 0) {
                    System.out.println(rb.getString(".X.not.signed.by.specified.alias.es."));
                }
                System.out.println();
            }
            if (cloneable == null) {
                System.out.println(rb.getString("no.manifest."));
            }
            if (!bl) {
                System.out.println(rb.getString("jar.is.unsigned.signatures.missing.or.not.parsable."));
            } else {
                boolean bl6;
                boolean bl62 = false;
                boolean bl7 = false;
                if (this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType || this.notYetValidCert || this.chainNotValidated || this.hasExpiredCert || this.hasUnsignedEntry || this.aliasNotInStore || this.notSignedByAlias) {
                    if (this.strict) {
                        System.out.println(rb.getString("jar.verified.with.signer.errors."));
                        System.out.println();
                        System.out.println(rb.getString("Error."));
                        bl6 = true;
                    } else {
                        System.out.println(rb.getString("jar.verified."));
                        System.out.println();
                        System.out.println(rb.getString("Warning."));
                        bl62 = true;
                    }
                    if (this.badKeyUsage) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing."));
                    }
                    if (this.badExtendedKeyUsage) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing."));
                    }
                    if (this.badNetscapeCertType) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing."));
                    }
                    if (this.hasUnsignedEntry) {
                        System.out.println(rb.getString("This.jar.contains.unsigned.entries.which.have.not.been.integrity.checked."));
                    }
                    if (this.hasExpiredCert) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.has.expired."));
                    }
                    if (this.notYetValidCert) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.is.not.yet.valid."));
                    }
                    if (this.chainNotValidated) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.certificate.chain.is.not.validated."));
                    }
                    if (this.notSignedByAlias) {
                        System.out.println(rb.getString("This.jar.contains.signed.entries.which.is.not.signed.by.the.specified.alias.es."));
                    }
                    if (this.aliasNotInStore) {
                        System.out.println(rb.getString("This.jar.contains.signed.entries.that.s.not.signed.by.alias.in.this.keystore."));
                    }
                } else {
                    System.out.println(rb.getString("jar.verified."));
                }
                if (this.hasExpiringCert || this.noTimestamp) {
                    if (!bl62) {
                        System.out.println();
                        System.out.println(rb.getString("Warning."));
                        bl62 = true;
                    }
                    if (this.hasExpiringCert) {
                        System.out.println(rb.getString("This.jar.contains.entries.whose.signer.certificate.will.expire.within.six.months."));
                    }
                    if (this.noTimestamp) {
                        System.out.println(String.format(rb.getString("no.timestamp.verifying"), this.expireDate));
                    }
                }
                if (!(!bl62 && !bl6 || this.verbose != null && this.showcerts)) {
                    System.out.println();
                    System.out.println(rb.getString("Re.run.with.the.verbose.and.certs.options.for.more.details."));
                }
            }
            return;
        }
        System.exit(1);
    }

    String printCert(String string, Certificate certificate, boolean bl, Date date, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rb.getString("SPACE");
        X509Certificate x509Certificate = null;
        if (certificate instanceof X509Certificate) {
            x509Certificate = (X509Certificate)certificate;
            stringBuilder.append(string).append(x509Certificate.getType()).append(rb.getString("COMMA")).append(x509Certificate.getSubjectDN().getName());
        } else {
            stringBuilder.append(string).append(certificate.getType());
        }
        String string3 = this.storeHash.get(certificate);
        if (string3 != null) {
            stringBuilder.append(string2).append(string3);
        }
        if (bl && x509Certificate != null) {
            Object object;
            stringBuilder.append("\n").append(string).append("[");
            Date date2 = x509Certificate.getNotAfter();
            try {
                boolean bl3 = true;
                if (date == null) {
                    if (this.expireDate.getTime() == 0L || this.expireDate.after(date2)) {
                        this.expireDate = date2;
                    }
                    x509Certificate.checkValidity();
                    if (date2.getTime() < System.currentTimeMillis() + 15552000000L) {
                        this.hasExpiringCert = true;
                        if (expiringTimeForm == null) {
                            expiringTimeForm = new MessageFormat(rb.getString("certificate.will.expire.on"));
                        }
                        object = new Object[]{date2};
                        stringBuilder.append(expiringTimeForm.format(object));
                        bl3 = false;
                    }
                } else {
                    x509Certificate.checkValidity(date);
                }
                if (bl3) {
                    if (validityTimeForm == null) {
                        validityTimeForm = new MessageFormat(rb.getString("certificate.is.valid.from"));
                    }
                    object = new Object[]{x509Certificate.getNotBefore(), date2};
                    stringBuilder.append(validityTimeForm.format(object));
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                this.hasExpiredCert = true;
                if (expiredTimeForm == null) {
                    expiredTimeForm = new MessageFormat(rb.getString("certificate.expired.on"));
                }
                object = new Object[]{date2};
                stringBuilder.append(expiredTimeForm.format(object));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                this.notYetValidCert = true;
                if (notYetTimeForm == null) {
                    notYetTimeForm = new MessageFormat(rb.getString("certificate.is.not.valid.until"));
                }
                object = new Object[]{x509Certificate.getNotBefore()};
                stringBuilder.append(notYetTimeForm.format(object));
            }
            stringBuilder.append("]");
            if (bl2) {
                boolean[] blArray = new boolean[3];
                this.checkCertUsage(x509Certificate, blArray);
                if (blArray[0] || blArray[1] || blArray[2]) {
                    object = "";
                    if (blArray[0]) {
                        object = "KeyUsage";
                    }
                    if (blArray[1]) {
                        if (((String)object).length() > 0) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "ExtendedKeyUsage";
                    }
                    if (blArray[2]) {
                        if (((String)object).length() > 0) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "NetscapeCertType";
                    }
                    stringBuilder.append("\n").append(string).append(MessageFormat.format(rb.getString(".{0}.extension.does.not.support.code.signing."), object));
                }
            }
        }
        return stringBuilder.toString();
    }

    private String printTimestamp(String string, Timestamp timestamp) {
        if (signTimeForm == null) {
            signTimeForm = new MessageFormat(rb.getString("entry.was.signed.on"));
        }
        Object[] objectArray = new Object[]{timestamp.getTimestamp()};
        return string + "[" + signTimeForm.format(objectArray) + "]";
    }

    private int inKeyStoreForOneSigner(CodeSigner codeSigner) {
        if (this.cacheForInKS.containsKey(codeSigner)) {
            return this.cacheForInKS.get(codeSigner);
        }
        boolean bl = false;
        int n = 0;
        List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
        for (Certificate certificate : list) {
            String string = this.storeHash.get(certificate);
            if (string != null) {
                if (string.startsWith("(")) {
                    n |= 1;
                } else if (string.startsWith("[")) {
                    n |= 2;
                }
                if (!this.ckaliases.contains(string.substring(1, string.length() - 1))) continue;
                n |= 8;
                continue;
            }
            if (this.store != null) {
                try {
                    string = this.store.getCertificateAlias(certificate);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (string != null) {
                    this.storeHash.put(certificate, "(" + string + ")");
                    bl = true;
                    n |= 1;
                }
            }
            if (!this.ckaliases.contains(string)) continue;
            n |= 8;
        }
        this.cacheForInKS.put(codeSigner, n);
        return n;
    }

    int inKeyStore(CodeSigner[] codeSignerArray) {
        if (codeSignerArray == null) {
            return 0;
        }
        int n = 0;
        for (CodeSigner codeSigner : codeSignerArray) {
            int n2 = this.inKeyStoreForOneSigner(codeSigner);
            n |= n2;
        }
        if (this.ckaliases.size() > 0 && (n & 8) == 0) {
            n |= 4;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signJar(String string, String string2, String[] stringArray) throws Exception {
        Object[] objectArray;
        Cloneable cloneable;
        Object object;
        boolean bl = false;
        X509Certificate x509Certificate = null;
        if (this.sigfile == null) {
            this.sigfile = string2;
            bl = true;
        }
        this.sigfile = this.sigfile.length() > 8 ? this.sigfile.substring(0, 8).toUpperCase(Locale.ENGLISH) : this.sigfile.toUpperCase(Locale.ENGLISH);
        StringBuilder stringBuilder = new StringBuilder(this.sigfile.length());
        for (int i = 0; i < this.sigfile.length(); ++i) {
            int n = this.sigfile.charAt(i);
            if (!(n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95)) {
                if (bl) {
                    n = 95;
                } else {
                    throw new RuntimeException(rb.getString("signature.filename.must.consist.of.the.following.characters.A.Z.0.9.or."));
                }
            }
            stringBuilder.append((char)n);
        }
        this.sigfile = stringBuilder.toString();
        String string3 = this.signedjar == null ? string + ".sig" : this.signedjar;
        File file = new File(string);
        File file2 = new File(string3);
        try {
            this.zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable.to.open.jar.file.") + string, iOException);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable.to.create.") + string3, iOException);
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(printStream);
        String string4 = (META_INF + this.sigfile + ".SF").toUpperCase(Locale.ENGLISH);
        String string5 = (META_INF + this.sigfile + ".DSA").toUpperCase(Locale.ENGLISH);
        Manifest manifest = new Manifest();
        Map<String, Attributes> map = manifest.getEntries();
        Attributes attributes = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object2 = null;
        try {
            ZipEntry zipEntry;
            Object object3;
            Object object4;
            Object object5;
            object = new MessageDigest[]{MessageDigest.getInstance(this.digestalg)};
            cloneable = this.getManifestFile(this.zipFile);
            if (cloneable != null) {
                object2 = this.getBytes(this.zipFile, (ZipEntry)cloneable);
                manifest.read(new ByteArrayInputStream((byte[])object2));
                attributes = (Attributes)manifest.getMainAttributes().clone();
            } else {
                objectArray = manifest.getMainAttributes();
                objectArray.putValue(Attributes.Name.MANIFEST_VERSION.toString(), VERSION);
                object5 = System.getProperty("java.vendor");
                String string6 = System.getProperty("java.version");
                objectArray.putValue("Created-By", string6 + " (" + (String)object5 + ")");
                cloneable = new ZipEntry("META-INF/MANIFEST.MF");
                bl3 = true;
            }
            objectArray = new JarBASE64Encoder();
            object5 = new Vector();
            boolean bl4 = false;
            Object object6 = this.zipFile.entries();
            while (object6.hasMoreElements()) {
                object4 = object6.nextElement();
                if (((ZipEntry)object4).getName().startsWith(META_INF)) {
                    ((Vector)object5).addElement(object4);
                    if (SignatureFileVerifier.isBlockOrSF(((ZipEntry)object4).getName().toUpperCase(Locale.ENGLISH))) {
                        bl4 = true;
                    }
                    if (this.signatureRelated(((ZipEntry)object4).getName())) continue;
                }
                if (manifest.getAttributes(((ZipEntry)object4).getName()) != null) {
                    if (!this.updateDigests((ZipEntry)object4, this.zipFile, (MessageDigest[])object, (BASE64Encoder)objectArray, manifest)) continue;
                    bl2 = true;
                    continue;
                }
                if (((ZipEntry)object4).isDirectory()) continue;
                Attributes attributes2 = this.getDigestAttributes((ZipEntry)object4, this.zipFile, (MessageDigest[])object, (BASE64Encoder)objectArray);
                map.put(((ZipEntry)object4).getName(), attributes2);
                bl2 = true;
            }
            if (bl2) {
                object6 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object6);
                if (bl4) {
                    object4 = ((ByteArrayOutputStream)object6).toByteArray();
                    if (object2 != null && attributes.equals(manifest.getMainAttributes())) {
                        int n;
                        int n2 = this.findHeaderEnd((byte[])object4);
                        if (n2 == (n = this.findHeaderEnd((byte[])object2))) {
                            System.arraycopy(object2, 0, object4, 0, n);
                        } else {
                            object3 = new byte[n + ((Object)object4).length - n2];
                            System.arraycopy(object2, 0, object3, 0, n);
                            System.arraycopy(object4, n2, object3, n, ((Object)object4).length - n2);
                            object4 = object3;
                        }
                    }
                    object2 = object4;
                } else {
                    object2 = ((ByteArrayOutputStream)object6).toByteArray();
                }
            }
            if (bl2) {
                cloneable = new ZipEntry("META-INF/MANIFEST.MF");
            }
            if (this.verbose != null) {
                if (bl3) {
                    System.out.println(rb.getString(".adding.") + ((ZipEntry)cloneable).getName());
                } else if (bl2) {
                    System.out.println(rb.getString(".updating.") + ((ZipEntry)cloneable).getName());
                }
            }
            zipOutputStream.putNextEntry((ZipEntry)cloneable);
            zipOutputStream.write((byte[])object2);
            object6 = new ManifestDigester((byte[])object2);
            object4 = new SignatureFile((MessageDigest[])object, manifest, (ManifestDigester)object6, this.sigfile, this.signManifest);
            if (this.tsaAlias != null) {
                x509Certificate = this.getTsaCert(this.tsaAlias);
            }
            if (this.tsaUrl == null && x509Certificate == null) {
                this.noTimestamp = true;
            }
            SignatureFile.Block block = null;
            try {
                block = ((SignatureFile)object4).generateBlock(this.privateKey, this.sigalg, this.certChain, this.externalSF, this.tsaUrl, x509Certificate, this.signingMechanism, stringArray, this.zipFile);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.error(rb.getString("unable.to.sign.jar.") + rb.getString("no.response.from.the.Timestamping.Authority.") + "\n  -J-Dhttp.proxyHost=<hostname>" + "\n  -J-Dhttp.proxyPort=<portnumber>\n" + rb.getString("or") + "\n  -J-Dhttps.proxyHost=<hostname> " + "\n  -J-Dhttps.proxyPort=<portnumber> ", socketTimeoutException);
            }
            string4 = ((SignatureFile)object4).getMetaName();
            string5 = block.getMetaName();
            ZipEntry zipEntry2 = new ZipEntry(string4);
            object3 = new ZipEntry(string5);
            long l = System.currentTimeMillis();
            zipEntry2.setTime(l);
            ((ZipEntry)object3).setTime(l);
            zipOutputStream.putNextEntry(zipEntry2);
            ((SignatureFile)object4).write(zipOutputStream);
            if (this.verbose != null) {
                if (this.zipFile.getEntry(string4) != null) {
                    System.out.println(rb.getString(".updating.") + string4);
                } else {
                    System.out.println(rb.getString(".adding.") + string4);
                }
            }
            if (this.verbose != null) {
                if (this.tsaUrl != null || x509Certificate != null) {
                    System.out.println(rb.getString("requesting.a.signature.timestamp"));
                }
                if (this.tsaUrl != null) {
                    System.out.println(rb.getString("TSA.location.") + this.tsaUrl);
                }
                if (x509Certificate != null) {
                    String string7 = TimestampedSigner.getTimestampingUrl(x509Certificate);
                    if (string7 != null) {
                        System.out.println(rb.getString("TSA.location.") + string7);
                    }
                    System.out.println(rb.getString("TSA.certificate.") + this.printCert("", x509Certificate, false, null, false));
                }
                if (this.signingMechanism != null) {
                    System.out.println(rb.getString("using.an.alternative.signing.mechanism"));
                }
            }
            zipOutputStream.putNextEntry((ZipEntry)object3);
            block.write(zipOutputStream);
            if (this.verbose != null) {
                if (this.zipFile.getEntry(string5) != null) {
                    System.out.println(rb.getString(".updating.") + string5);
                } else {
                    System.out.println(rb.getString(".adding.") + string5);
                }
            }
            for (int i = 0; i < ((Vector)object5).size(); ++i) {
                zipEntry = (ZipEntry)((Vector)object5).elementAt(i);
                if (zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || zipEntry.getName().equalsIgnoreCase(string4) || zipEntry.getName().equalsIgnoreCase(string5)) continue;
                this.writeEntry(this.zipFile, zipOutputStream, zipEntry);
            }
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.getName().startsWith(META_INF)) continue;
                if (this.verbose != null) {
                    if (manifest.getAttributes(zipEntry.getName()) != null) {
                        System.out.println(rb.getString(".signing.") + zipEntry.getName());
                    } else {
                        System.out.println(rb.getString(".adding.") + zipEntry.getName());
                    }
                }
                this.writeEntry(this.zipFile, zipOutputStream, zipEntry);
            }
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable.to.sign.jar.") + iOException, iOException);
        }
        finally {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
        if (this.signedjar == null && !file2.renameTo(file)) {
            object = new File(string + ".orig");
            if (file.renameTo((File)object)) {
                if (file2.renameTo(file)) {
                    ((File)object).delete();
                } else {
                    cloneable = new MessageFormat(rb.getString("attempt.to.rename.signedJarFile.to.jarFile.failed"));
                    objectArray = new Object[]{file2, file};
                    this.error(((Format)cloneable).format(objectArray));
                }
            } else {
                cloneable = new MessageFormat(rb.getString("attempt.to.rename.jarFile.to.origJar.failed"));
                objectArray = new Object[]{file, object};
                this.error(((Format)cloneable).format(objectArray));
            }
        }
        boolean bl5 = false;
        if (this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType || this.notYetValidCert || this.chainNotValidated || this.hasExpiredCert) {
            if (this.strict) {
                System.out.println(rb.getString("jar.signed.with.signer.errors."));
                System.out.println();
                System.out.println(rb.getString("Error."));
            } else {
                System.out.println(rb.getString("jar.signed."));
                System.out.println();
                System.out.println(rb.getString("Warning."));
                bl5 = true;
            }
            if (this.badKeyUsage) {
                System.out.println(rb.getString("The.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing."));
            }
            if (this.badExtendedKeyUsage) {
                System.out.println(rb.getString("The.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing."));
            }
            if (this.badNetscapeCertType) {
                System.out.println(rb.getString("The.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing."));
            }
            if (this.hasExpiredCert) {
                System.out.println(rb.getString("The.signer.certificate.has.expired."));
            } else if (this.notYetValidCert) {
                System.out.println(rb.getString("The.signer.certificate.is.not.yet.valid."));
            }
            if (this.chainNotValidated) {
                System.out.println(rb.getString("The.signer.s.certificate.chain.is.not.validated."));
            }
        } else {
            System.out.println(rb.getString("jar.signed."));
        }
        if (this.hasExpiringCert || this.noTimestamp) {
            if (!bl5) {
                System.out.println();
                System.out.println(rb.getString("Warning."));
            }
            if (this.hasExpiringCert) {
                System.out.println(rb.getString("The.signer.certificate.will.expire.within.six.months."));
            }
            if (this.noTimestamp) {
                System.out.println(String.format(rb.getString("no.timestamp.signing"), this.expireDate));
            }
        }
    }

    private int findHeaderEnd(byte[] byArray) {
        boolean bl = true;
        int n = byArray.length;
        block4: for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 13: {
                    if (i < n - 1 && byArray[i + 1] == 10) {
                        ++i;
                    }
                }
                case 10: {
                    if (bl) {
                        return i + 1;
                    }
                    bl = true;
                    continue block4;
                }
                default: {
                    bl = false;
                }
            }
        }
        return n;
    }

    private boolean signatureRelated(String string) {
        return SignatureFileVerifier.isSigningRelated(string);
    }

    private String signerInfo(CodeSigner codeSigner, String string) {
        StringBuffer stringBuffer;
        block7: {
            Date date;
            if (this.cacheForSignerInfo.containsKey(codeSigner)) {
                return this.cacheForSignerInfo.get(codeSigner);
            }
            stringBuffer = new StringBuffer();
            List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
            Timestamp timestamp = codeSigner.getTimestamp();
            if (timestamp != null) {
                stringBuffer.append(this.printTimestamp(string, timestamp));
                stringBuffer.append('\n');
                date = timestamp.getTimestamp();
            } else {
                date = null;
                this.noTimestamp = true;
            }
            boolean bl = true;
            for (Certificate certificate : list) {
                stringBuffer.append(this.printCert(string, certificate, true, date, bl));
                stringBuffer.append('\n');
                bl = false;
            }
            try {
                this.validateCertChain(list);
            }
            catch (Exception exception) {
                if (this.debug) {
                    exception.printStackTrace();
                }
                if (exception.getCause() != null && (exception.getCause() instanceof CertificateExpiredException || exception.getCause() instanceof CertificateNotYetValidException)) break block7;
                this.chainNotValidated = true;
                stringBuffer.append(string + rb.getString(".CertPath.not.validated.") + exception.getLocalizedMessage() + "]\n");
            }
        }
        String string2 = stringBuffer.toString();
        this.cacheForSignerInfo.put(codeSigner, string2);
        return string2;
    }

    private void writeEntry(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setMethod(zipEntry.getMethod());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setExtra(zipEntry.getExtra());
        if (zipEntry.getMethod() == 0) {
            zipEntry2.setSize(zipEntry.getSize());
            zipEntry2.setCrc(zipEntry.getCrc());
        }
        zipOutputStream.putNextEntry(zipEntry2);
        this.writeBytes(zipFile, zipEntry, zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeBytes(ZipFile zipFile, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            inputStream = zipFile.getInputStream(zipEntry);
            for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n) {
                zipOutputStream.write(this.buffer, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadKeyStore(String string, boolean bl) {
        if (!this.nullStream && string == null) {
            string = System.getProperty("user.home") + File.separator + ".keystore";
        }
        try {
            Object object;
            Object object2;
            Object object3;
            this.certificateFactory = CertificateFactory.getInstance("X.509");
            this.validator = CertPathValidator.getInstance("PKIX");
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            try {
                object3 = KeyTool.getCacertsKeyStore();
                if (object3 != null) {
                    object2 = ((KeyStore)object3).aliases();
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        try {
                            hashSet.add(new TrustAnchor((X509Certificate)((KeyStore)object3).getCertificate((String)object), null));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.store = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
            if (this.token && this.storepass == null && !this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.storepass = this.getPass(rb.getString("Enter.Passphrase.for.keystore."));
            } else if (!this.token && this.storepass == null && bl) {
                this.storepass = this.getPass(rb.getString("Enter.Passphrase.for.keystore."));
            }
            try {
                if (this.nullStream) {
                    this.store.load(null, this.storepass);
                } else {
                    string = string.replace(File.separatorChar, '/');
                    object3 = null;
                    try {
                        object3 = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        object3 = new File(string).toURI().toURL();
                    }
                    object2 = null;
                    try {
                        object2 = ((URL)object3).openStream();
                        this.store.load((InputStream)object2, this.storepass);
                    }
                    finally {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                    }
                }
                object3 = this.store.aliases();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    try {
                        object = (X509Certificate)this.store.getCertificate((String)object2);
                        if (!this.store.isCertificateEntry((String)object2) && !((X509Certificate)object).getSubjectDN().equals(((X509Certificate)object).getIssuerDN())) continue;
                        hashSet.add(new TrustAnchor((X509Certificate)object, null));
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    this.pkixParameters = new PKIXParameters(hashSet);
                    this.pkixParameters.setRevocationEnabled(false);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(rb.getString("keystore.load.") + iOException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(rb.getString("certificate.exception.") + certificateException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(rb.getString("keystore.load.") + noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(rb.getString("keystore.load.") + noSuchAlgorithmException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException(rb.getString("unable.to.instantiate.keystore.class.") + keyStoreException.getMessage());
        }
    }

    X509Certificate getTsaCert(String string) {
        Certificate certificate = null;
        try {
            certificate = this.store.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate.not.found.for.alias.alias.must.reference.a.valid.KeyStore.entry.containing.an.X.509.public.key.certificate.for.the"));
            Object[] objectArray = new Object[]{string, string};
            this.error(messageFormat.format(objectArray));
        }
        return (X509Certificate)certificate;
    }

    void checkCertUsage(X509Certificate x509Certificate, boolean[] blArray) {
        Object object;
        boolean[] blArray2;
        if (blArray != null) {
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
        }
        if ((blArray2 = x509Certificate.getKeyUsage()) != null && !(blArray2 = Arrays.copyOf(blArray2, 9))[0] && !blArray2[1] && blArray != null) {
            blArray[0] = true;
            this.badKeyUsage = true;
        }
        try {
            object = x509Certificate.getExtendedKeyUsage();
            if (object != null && !object.contains("2.5.29.37.0") && !object.contains("1.3.6.1.5.5.7.3.3") && blArray != null) {
                blArray[1] = true;
                this.badExtendedKeyUsage = true;
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        try {
            object = x509Certificate.getExtensionValue("2.16.840.1.113730.1.1");
            if (object != null) {
                DerInputStream derInputStream = new DerInputStream((byte[])object);
                byte[] byArray = derInputStream.getOctetString();
                NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray = new DerValue(byArray).getUnalignedBitString().toByteArray());
                Boolean bl = (Boolean)netscapeCertTypeExtension.get("object_signing");
                if (!bl.booleanValue() && blArray != null) {
                    blArray[2] = true;
                    this.badNetscapeCertType = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void getAliasInfo(String string) {
        Object object;
        Key key;
        block27: {
            key = null;
            try {
                Object object2;
                block26: {
                    object = null;
                    if (this.altCertChain != null) {
                        try {
                            object = CertificateFactory.getInstance("X.509").generateCertificates(new FileInputStream(this.altCertChain)).toArray(new Certificate[0]);
                        }
                        catch (CertificateException certificateException) {
                            this.error(rb.getString("Cannot.restore.certchain.from.file.specified"));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.error(rb.getString("File.specified.by.certchain.does.not.exist"));
                        }
                    } else {
                        try {
                            object = this.store.getCertificateChain(string);
                        }
                        catch (KeyStoreException keyStoreException) {
                            // empty catch block
                        }
                    }
                    if (object == null || ((Certificate[])object).length == 0) {
                        if (this.altCertChain != null) {
                            this.error(rb.getString("Certificate.chain.not.found.in.the.file.specified."));
                        } else {
                            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate.chain.not.found.for.alias.alias.must.reference.a.valid.KeyStore.key.entry.containing.a.private.key.and"));
                            object2 = new Object[]{string, string};
                            this.error(messageFormat.format(object2));
                        }
                    }
                    this.certChain = new X509Certificate[((Certificate[])object).length];
                    for (int i = 0; i < ((Certificate[])object).length; ++i) {
                        if (!(object[i] instanceof X509Certificate)) {
                            this.error(rb.getString("found.non.X.509.certificate.in.signer.s.chain"));
                        }
                        this.certChain[i] = (X509Certificate)object[i];
                    }
                    this.printCert("", this.certChain[0], true, null, true);
                    try {
                        this.validateCertChain(Arrays.asList(this.certChain));
                    }
                    catch (Exception exception) {
                        if (this.debug) {
                            exception.printStackTrace();
                        }
                        if (exception.getCause() != null && (exception.getCause() instanceof CertificateExpiredException || exception.getCause() instanceof CertificateNotYetValidException)) break block26;
                        this.chainNotValidated = true;
                    }
                }
                try {
                    if (!this.token && this.keypass == null) {
                        key = this.store.getKey(string, this.storepass);
                        break block27;
                    }
                    key = this.store.getKey(string, this.keypass);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    if (this.token) {
                        throw unrecoverableKeyException;
                    }
                    if (this.keypass == null) {
                        object2 = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                        Object[] objectArray = new Object[]{string};
                        this.keypass = this.getPass(((Format)object2).format(objectArray));
                        key = this.store.getKey(string, this.keypass);
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.error(noSuchAlgorithmException.getMessage());
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.error(rb.getString("unable.to.recover.key.from.keystore"));
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        if (!(key instanceof PrivateKey)) {
            object = new MessageFormat(rb.getString("key.associated.with.alias.not.a.private.key"));
            Object[] objectArray = new Object[]{string};
            this.error(((Format)object).format(objectArray));
        } else {
            this.privateKey = (PrivateKey)key;
        }
    }

    void error(String string) {
        System.out.println(rb.getString("jarsigner.") + string);
        System.exit(1);
    }

    void error(String string, Exception exception) {
        System.out.println(rb.getString("jarsigner.") + string);
        if (this.debug) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    void validateCertChain(List<? extends Certificate> list) throws Exception {
        int n;
        block0: for (n = 0; n < list.size(); ++n) {
            for (TrustAnchor trustAnchor : this.pkixParameters.getTrustAnchors()) {
                if (!trustAnchor.getTrustedCert().equals(list.get(n))) continue;
                break block0;
            }
        }
        if (n > 0) {
            CertPath certPath = this.certificateFactory.generateCertPath(n == list.size() ? list : list.subList(0, n));
            this.validator.validate(certPath, this.pkixParameters);
        }
    }

    char[] getPass(String string) {
        System.err.print(string);
        System.err.flush();
        try {
            char[] cArray = Password.readPassword(System.in);
            if (cArray != null) {
                return cArray;
            }
            this.error(rb.getString("you.must.enter.key.password"));
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable.to.read.password.") + iOException.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] getBytes(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            inputStream = zipFile.getInputStream(zipEntry);
            this.baos.reset();
            for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n) {
                this.baos.write(this.buffer, 0, n);
            }
        }
        return this.baos.toByteArray();
    }

    private ZipEntry getManifestFile(ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements() && zipEntry == null) {
                zipEntry = enumeration.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(zipEntry.getName())) continue;
                zipEntry = null;
            }
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] getDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        int n;
        try (InputStream inputStream = null;){
            int n2;
            inputStream = zipFile.getInputStream(zipEntry);
            for (long i = zipEntry.getSize(); i > 0L && (n2 = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n2) {
                for (n = 0; n < messageDigestArray.length; ++n) {
                    messageDigestArray[n].update(this.buffer, 0, n2);
                }
            }
        }
        String[] stringArray = new String[messageDigestArray.length];
        for (n = 0; n < messageDigestArray.length; ++n) {
            stringArray[n] = bASE64Encoder.encode(messageDigestArray[n].digest());
        }
        return stringArray;
    }

    private Attributes getDigestAttributes(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        Attributes attributes = new Attributes();
        for (int i = 0; i < messageDigestArray.length; ++i) {
            attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", stringArray[i]);
        }
        return attributes;
    }

    private boolean updateDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder, Manifest manifest) throws IOException {
        boolean bl = false;
        Attributes attributes = manifest.getAttributes(zipEntry.getName());
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        for (int i = 0; i < messageDigestArray.length; ++i) {
            Object object;
            String string = null;
            try {
                object = AlgorithmId.get(messageDigestArray[i].getAlgorithm());
                for (Object object2 : attributes.keySet()) {
                    String string2;
                    String string3;
                    if (!(object2 instanceof Attributes.Name) || !(string3 = ((Attributes.Name)object2).toString()).toUpperCase(Locale.ENGLISH).endsWith("-DIGEST") || !AlgorithmId.get(string2 = string3.substring(0, string3.length() - 7)).equals((AlgorithmId)object)) continue;
                    string = string3;
                    break;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (string == null) {
                string = messageDigestArray[i].getAlgorithm() + "-Digest";
                attributes.putValue(string, stringArray[i]);
                bl = true;
                continue;
            }
            object = attributes.getValue(string);
            if (((String)object).equalsIgnoreCase(stringArray[i])) continue;
            attributes.putValue(string, stringArray[i]);
            bl = true;
        }
        return bl;
    }

    private ContentSigner loadSigningMechanism(String string, String string2) throws Exception {
        String string3 = null;
        string3 = PathList.appendPath((String)System.getProperty("env.class.path"), string3);
        string3 = PathList.appendPath((String)System.getProperty("java.class.path"), (String)string3);
        URL[] uRLArray = PathList.pathToURLs((String)(string3 = PathList.appendPath((String)string2, (String)string3)));
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Class<?> clazz = uRLClassLoader.loadClass(string);
        Object obj = clazz.newInstance();
        if (!(obj instanceof ContentSigner)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("signerClass.is.not.a.signing.mechanism"));
            Object[] objectArray = new Object[]{clazz.getName()};
            throw new IllegalArgumentException(messageFormat.format(objectArray));
        }
        return (ContentSigner)obj;
    }

    static {
        collator.setStrength(0);
        PARAM_STRING = new Class[]{String.class};
        validityTimeForm = null;
        notYetTimeForm = null;
        expiredTimeForm = null;
        expiringTimeForm = null;
        signTimeForm = null;
    }
}

