/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.rmi.rmic.Main;
import sun.tools.java.ClassPath;

public class BatchEnvironment
extends sun.tools.javac.BatchEnvironment {
    private Main main;
    private Vector<File> generatedFiles = new Vector();

    public static ClassPath createClassPath(String string) {
        ClassPath[] classPathArray = BatchEnvironment.classPaths(null, string, null, null);
        return classPathArray[1];
    }

    public static ClassPath createClassPath(String string, String string2, String string3) {
        Path path = new Path();
        if (string2 == null) {
            string2 = System.getProperty("sun.boot.class.path");
        }
        if (string2 != null) {
            path.addFiles(string2);
        }
        path.expandJarClassPaths(true);
        if (string3 == null) {
            string3 = System.getProperty("java.ext.dirs");
        }
        if (string3 != null) {
            path.addDirectories(string3);
        }
        path.emptyPathDefault(".");
        if (string == null && (string = System.getProperty("env.class.path")) == null) {
            string = ".";
        }
        path.addFiles(string);
        return new ClassPath(path.toArray(new String[path.size()]));
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, Main main) {
        super(outputStream, new ClassPath(""), classPath);
        this.main = main;
    }

    public Main getMain() {
        return this.main;
    }

    public ClassPath getClassPath() {
        return this.binaryPath;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.addElement(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        Vector<File> vector = this.generatedFiles;
        synchronized (vector) {
            Enumeration<File> enumeration = this.generatedFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = enumeration.nextElement();
                file.delete();
            }
            this.generatedFiles.removeAllElements();
        }
    }

    @Override
    public void shutdown() {
        this.main = null;
        this.generatedFiles = null;
        super.shutdown();
    }

    @Override
    public String errorString(String string, Object object, Object object2, Object object3) {
        if (string.startsWith("rmic.") || string.startsWith("warn.rmic.")) {
            String string2 = Main.getText(string, object != null ? object.toString() : null, object2 != null ? object2.toString() : null, object3 != null ? object3.toString() : null);
            if (string.startsWith("warn.")) {
                string2 = "warning: " + string2;
            }
            return string2;
        }
        return super.errorString(string, object, object2, object3);
    }

    public void reset() {
    }

    private static class Path
    extends LinkedHashSet<String> {
        private static final long serialVersionUID = 0L;
        private static final boolean warn = false;
        private boolean expandJarClassPaths = false;
        private String emptyPathDefault = null;

        private static boolean isZip(String string) {
            return new File(string).isFile();
        }

        public Path expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public Path emptyPathDefault(String string) {
            this.emptyPathDefault = string;
            return this;
        }

        public Path addDirectories(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string)) {
                    this.addDirectory(string2, bl);
                }
            }
            return this;
        }

        public Path addDirectories(String string) {
            return this.addDirectories(string, false);
        }

        private void addDirectory(String string, boolean bl) {
            if (!new File(string).isDirectory()) {
                return;
            }
            for (String string2 : new File(string).list()) {
                String string3 = string2.toLowerCase();
                if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
                this.addFile(string + File.separator + string2, bl);
            }
        }

        public Path addFiles(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string, this.emptyPathDefault)) {
                    this.addFile(string2, bl);
                }
            }
            return this;
        }

        public Path addFiles(String string) {
            return this.addFiles(string, false);
        }

        private void addFile(String string, boolean bl) {
            String string2;
            if (this.contains(string)) {
                return;
            }
            File file = new File(string);
            if (!file.exists() && bl) {
                return;
            }
            if (file.isFile() && !(string2 = string.toLowerCase()).endsWith(".zip") && !string2.endsWith(".jar")) {
                return;
            }
            super.add(string);
            if (this.expandJarClassPaths && Path.isZip(string)) {
                this.addJarClassPath(string, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addJarClassPath(String string, boolean bl) {
            try {
                String string2 = new File(string).getParent();
                try (JarFile jarFile = new JarFile(string);){
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null) {
                        return;
                    }
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null) {
                        return;
                    }
                    String string3 = attributes.getValue(Attributes.Name.CLASS_PATH);
                    if (string3 == null) {
                        return;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string2 != null) {
                            string4 = new File(string2, string4).getCanonicalPath();
                        }
                        this.addFile(string4, bl);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static class PathIterator
        implements Collection<String> {
            private int pos = 0;
            private final String path;
            private final String emptyPathDefault;

            public PathIterator(String string, String string2) {
                this.path = string;
                this.emptyPathDefault = string2;
            }

            public PathIterator(String string) {
                this(string, null);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return PathIterator.this.pos <= PathIterator.this.path.length();
                    }

                    @Override
                    public String next() {
                        int n = PathIterator.this.pos;
                        int n2 = PathIterator.this.path.indexOf(File.pathSeparator, n);
                        if (n2 == -1) {
                            n2 = PathIterator.this.path.length();
                        }
                        PathIterator.this.pos = n2 + 1;
                        if (n == n2 && PathIterator.this.emptyPathDefault != null) {
                            return PathIterator.this.emptyPathDefault;
                        }
                        return PathIterator.this.path.substring(n, n2);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends String> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

