/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.ArrayList;
import java.util.List;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.InnerTypeLocation;

public abstract class TypeASTMapper<N> {
    protected TypeASTMapper() {
    }

    private static ATypeElement getInnerType(ATypeElement te, List<TypeAnnotationPosition.TypePathEntry> ls) {
        if (ls.isEmpty()) {
            return te;
        }
        return te.innerTypes.vivify(new InnerTypeLocation(ls));
    }

    public void traverse(N tastRoot, ATypeElement aslRoot) {
        ArrayList<TypeAnnotationPosition.TypePathEntry> ls = new ArrayList<TypeAnnotationPosition.TypePathEntry>();
        this.traverse1(tastRoot, aslRoot, ls);
    }

    private void traverse1(N n, ATypeElement te, List<TypeAnnotationPosition.TypePathEntry> ls) {
        N elType = this.getElementType(n);
        if (elType == null) {
            this.map(n, TypeASTMapper.getInnerType(te, ls));
            int nta = this.numTypeArguments(n);
            for (int tai = 0; tai < nta; ++tai) {
                ls.add(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, tai));
                this.traverse1(this.getTypeArgument(n, tai), te, ls);
                ls.remove(ls.size() - 1);
            }
        } else {
            this.map(n, TypeASTMapper.getInnerType(te, ls));
            int layers = 0;
            while ((elType = this.getElementType(n)) != null) {
                ls.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                this.map(elType, TypeASTMapper.getInnerType(te, ls));
                n = elType;
                ++layers;
            }
            int nta = this.numTypeArguments(n);
            for (int tai = 0; tai < nta; ++tai) {
                ls.add(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, tai));
                this.traverse1(this.getTypeArgument(n, tai), te, ls);
                ls.remove(ls.size() - 1);
            }
            for (int i = 0; i < layers; ++i) {
                ls.remove(ls.size() - 1);
            }
        }
    }

    protected abstract N getElementType(N var1);

    protected abstract int numTypeArguments(N var1);

    protected abstract N getTypeArgument(N var1, int var2);

    protected abstract void map(N var1, ATypeElement var2);
}

