/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.options;

import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class StringBuilderDelimited
implements Appendable,
CharSequence {
    private StringBuilder delegate = new StringBuilder();
    private boolean empty = true;
    private final String delimiter;

    public StringBuilderDelimited(String delimiter) {
        this.delimiter = delimiter;
    }

    private void appendDelimiter(@GuardSatisfied StringBuilderDelimited this) {
        if (this.empty) {
            this.empty = false;
        } else {
            this.delegate.append(this.delimiter);
        }
    }

    public StringBuilderDelimited add(CharSequence newElement) {
        this.appendDelimiter();
        this.delegate.append(newElement);
        return this;
    }

    @Deprecated
    public StringBuilderDelimited append(@Nullable String str) {
        this.appendDelimiter();
        this.delegate.append(str);
        return this;
    }

    @Deprecated
    public StringBuilderDelimited append(@Nullable Object o) {
        this.appendDelimiter();
        this.delegate.append(o);
        return this;
    }

    @Override
    @Deprecated
    public StringBuilderDelimited append(char c) {
        this.appendDelimiter();
        this.delegate.append(c);
        return this;
    }

    @Override
    @Deprecated
    public StringBuilderDelimited append(@Nullable CharSequence csq) {
        this.appendDelimiter();
        this.delegate.append(csq);
        return this;
    }

    @Override
    @Deprecated
    public StringBuilderDelimited append(@Nullable CharSequence csq, @IndexOrHigh(value={"#1"}) int start, @IndexOrHigh(value={"#1"}) int end) {
        this.appendDelimiter();
        this.delegate.append(csq, start, end);
        return this;
    }

    @Override
    @Deprecated
    public char charAt(@IndexFor(value={"this"}) int index) {
        return this.delegate.charAt(index);
    }

    @Override
    @Pure
    public @NonNegative int length(@GuardSatisfied StringBuilderDelimited this) {
        return this.delegate.length();
    }

    @Override
    @Deprecated
    public CharSequence subSequence(@IndexOrHigh(value={"this"}) int start, @IndexOrHigh(value={"this"}) int end) {
        return this.delegate.subSequence(start, end);
    }

    @Override
    @SideEffectFree
    public String toString(@GuardSatisfied StringBuilderDelimited this) {
        return this.delegate.toString();
    }
}

