/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import java.util.List;
import javax.lang.model.element.Element;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.TargetedElementAnnotationApplier;

public class TypeDeclarationApplier
extends TargetedElementAnnotationApplier {
    public static final int SUPERCLASS_INDEX = -1;
    private final AnnotatedTypeFactory typeFactory;
    private final Symbol.ClassSymbol typeSymbol;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType declaredType;

    public static void apply(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        new TypeDeclarationApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror type, Element element) {
        return type instanceof AnnotatedTypeMirror.AnnotatedDeclaredType && element instanceof Symbol.ClassSymbol;
    }

    TypeDeclarationApplier(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element);
        this.typeFactory = typeFactory;
        this.typeSymbol = (Symbol.ClassSymbol)element;
        this.declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)type;
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.RESOURCE_VARIABLE, TargetType.EXCEPTION_PARAMETER, TargetType.NEW, TargetType.CAST, TargetType.INSTANCEOF, TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, TargetType.METHOD_REFERENCE, TargetType.CONSTRUCTOR_REFERENCE, TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, TargetType.CLASS_TYPE_PARAMETER, TargetType.CLASS_TYPE_PARAMETER_BOUND};
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{TargetType.CLASS_EXTENDS};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.typeSymbol.getRawTypeAttributes();
    }

    @Override
    protected void handleTargeted(List<Attribute.TypeCompound> extendsAndImplementsAnnos) {
        for (Attribute.TypeCompound anno : extendsAndImplementsAnnos) {
            if (anno.position.type_index < -1 || !anno.position.location.isEmpty()) continue;
            this.type.addAnnotation(anno);
        }
    }

    @Override
    public void extractAndApply() {
        super.extractAndApply();
        this.type.addAnnotations(this.typeSymbol.getAnnotationMirrors());
        ElementAnnotationUtil.applyAllElementAnnotations(this.declaredType.getTypeArguments(), this.typeSymbol.getTypeParameters(), this.typeFactory);
    }

    @Override
    protected boolean isAccepted() {
        return TypeDeclarationApplier.accepts(this.type, this.element);
    }
}

