/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.OffsetDependentTypesHelper;
import org.checkerframework.checker.index.qual.LessThan;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class LessThanAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror BOTTOM;
    public final AnnotationMirror UNKNOWN;

    public LessThanAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, LessThanBottom.class);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, LessThanUnknown.class);
        this.postInit();
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(LessThan.class, LessThanUnknown.class, LessThanBottom.class));
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new OffsetDependentTypesHelper(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new LessThanQualifierHierarchy(factory);
    }

    public boolean isLessThan(Tree left, String right) {
        AnnotatedTypeMirror leftATM = this.getAnnotatedType(left);
        if (leftATM.getAnnotations().size() != 1) {
            return false;
        }
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(leftATM.getAnnotations().iterator().next());
        if (expressions == null) {
            return true;
        }
        return expressions.contains(right);
    }

    public boolean isLessThanByValue(Tree smaller, String bigger, TreePath path) {
        Long smallerValue = IndexUtil.getMinValue(smaller, this.getValueAnnotatedTypeFactory());
        if (smallerValue == null) {
            return false;
        }
        OffsetEquation offsetEquation = OffsetEquation.createOffsetFromJavaExpression(bigger);
        if (offsetEquation.isInt()) {
            return smallerValue < (long)offsetEquation.getInt();
        }
        smallerValue = smallerValue - (long)offsetEquation.getInt();
        offsetEquation = offsetEquation.copyAdd('-', OffsetEquation.createOffsetForInt(offsetEquation.getInt()));
        long minValueOfBigger = this.getMinValueFromString(offsetEquation.toString(), smaller, path);
        return smallerValue < minValueOfBigger;
    }

    private long getMinValueFromString(String expression, Tree tree, TreePath path) {
        AnnotationMirror intRange = null;
        try {
            intRange = this.getValueAnnotatedTypeFactory().getAnnotationFromJavaExpressionString(expression, tree, path, IntRange.class);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        if (intRange != null) {
            return ValueAnnotatedTypeFactory.getRange(intRange).from;
        }
        AnnotationMirror intValue = null;
        try {
            intValue = this.getValueAnnotatedTypeFactory().getAnnotationFromJavaExpressionString(expression, tree, path, IntVal.class);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        if (intValue != null) {
            List<Long> possibleValues = ValueAnnotatedTypeFactory.getIntValues(intValue);
            return Collections.min(possibleValues);
        }
        return Long.MIN_VALUE;
    }

    public boolean isLessThanOrEqual(Tree left, String right) {
        AnnotatedTypeMirror leftATM = this.getAnnotatedType(left);
        if (leftATM.getAnnotations().size() != 1) {
            return false;
        }
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(leftATM.getAnnotations().iterator().next());
        if (expressions == null) {
            return true;
        }
        if (expressions.contains(right)) {
            return true;
        }
        for (String expression : expressions) {
            if (!expression.endsWith(" + 1") || !expression.substring(0, expression.length() - 4).equals(right)) continue;
            return true;
        }
        return false;
    }

    public List<String> getLessThanExpressions(ExpressionTree expression) {
        AnnotatedTypeMirror annotatedTypeMirror = this.getAnnotatedType(expression);
        if (annotatedTypeMirror.getAnnotations().size() != 1) {
            return new ArrayList<String>();
        }
        return LessThanAnnotatedTypeFactory.getLessThanExpressions(annotatedTypeMirror.getAnnotations().iterator().next());
    }

    public AnnotationMirror createLessThanQualifier(List<String> expressions) {
        if (expressions == null) {
            return this.BOTTOM;
        }
        if (expressions.isEmpty()) {
            return this.UNKNOWN;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, LessThan.class);
        builder.setValue((CharSequence)"value", expressions);
        return builder.build();
    }

    public AnnotationMirror createLessThanQualifier(String expression) {
        return this.createLessThanQualifier(Collections.singletonList(expression));
    }

    public static List<String> getLessThanExpressions(AnnotationMirror annotation2) {
        if (AnnotationUtils.areSameByClass(annotation2, LessThanBottom.class)) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(annotation2, LessThanUnknown.class)) {
            return new ArrayList<String>();
        }
        List<String> list = AnnotationUtils.getElementValueArray(annotation2, "value", String.class, true);
        return list;
    }

    class LessThanQualifierHierarchy
    extends GraphQualifierHierarchy {
        public LessThanQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, LessThanAnnotatedTypeFactory.this.BOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            List<String> subList = LessThanAnnotatedTypeFactory.getLessThanExpressions(subAnno);
            List<String> superList = LessThanAnnotatedTypeFactory.getLessThanExpressions(superAnno);
            if (subList == null) {
                return true;
            }
            if (superList == null) {
                return false;
            }
            return subList.containsAll(superList);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            List<String> a1List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a1);
            List<String> a2List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a2);
            ArrayList<String> lub = new ArrayList<String>(a1List);
            lub.retainAll(a2List);
            return LessThanAnnotatedTypeFactory.this.createLessThanQualifier(lub);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            List<String> a1List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a1);
            List<String> a2List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a2);
            ArrayList<String> glb = new ArrayList<String>(a1List);
            glb.addAll(a2List);
            return LessThanAnnotatedTypeFactory.this.createLessThanQualifier(glb);
        }
    }
}

