/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.model;

import com.sun.tools.internal.xjc.api.ClassNameAllocator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoClassNameAllocator
implements ClassNameAllocator {
    private final ClassNameAllocator core;
    private final Map<String, Set<String>> names = new HashMap<String, Set<String>>();

    public AutoClassNameAllocator(ClassNameAllocator core) {
        this.core = core;
    }

    @Override
    public String assignClassName(String packageName, String className) {
        className = this.determineName(packageName, className);
        if (this.core != null) {
            className = this.core.assignClassName(packageName, className);
        }
        return className;
    }

    private String determineName(String packageName, String className) {
        Set<String> s2 = this.names.get(packageName);
        if (s2 == null) {
            s2 = new HashSet<String>();
            this.names.put(packageName, s2);
        }
        if (s2.add(className)) {
            return className;
        }
        int i = 2;
        while (!s2.add(className + i)) {
            ++i;
        }
        return className + i;
    }
}

