/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.Messages;
import java.io.OutputStream;
import java.io.PrintStream;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
extends ErrorReceiver {
    private PrintStream output;
    private boolean hadError = false;

    public ConsoleErrorReporter(PrintStream out) {
        this.output = out;
    }

    public ConsoleErrorReporter(OutputStream out) {
        this(new PrintStream(out));
    }

    public ConsoleErrorReporter() {
        this(System.out);
    }

    @Override
    public void warning(SAXParseException e) {
        this.print("Driver.WarningMessage", e);
    }

    @Override
    public void error(SAXParseException e) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", e);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", e);
    }

    @Override
    public void info(SAXParseException e) {
        this.print("Driver.InfoMessage", e);
    }

    public boolean hadError() {
        return this.hadError;
    }

    private void print(String resource, SAXParseException e) {
        this.output.println(Messages.format(resource, e.getMessage()));
        this.output.println(this.getLocationString(e));
        this.output.println();
    }
}

