/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.server.QueryHandler;
import java.util.Arrays;
import java.util.Comparator;

public class HistogramQuery
extends QueryHandler {
    @Override
    public void run() {
        JavaClass[] javaClassArray = this.snapshot.getClassesArray();
        Comparator<JavaClass> comparator = this.query.equals("count") ? new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass javaClass, JavaClass javaClass2) {
                long l = javaClass2.getInstancesCount(false) - javaClass.getInstancesCount(false);
                return l == 0L ? 0 : (l < 0L ? -1 : 1);
            }
        } : (this.query.equals("class") ? new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass javaClass, JavaClass javaClass2) {
                return javaClass.getName().compareTo(javaClass2.getName());
            }
        } : new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass javaClass, JavaClass javaClass2) {
                long l = javaClass2.getTotalInstanceSize() - javaClass.getTotalInstanceSize();
                return l == 0L ? 0 : (l < 0L ? -1 : 1);
            }
        });
        Arrays.sort(javaClassArray, comparator);
        this.startHtml("Heap Histogram");
        this.out.println("<p align='center'>");
        this.out.println("<b><a href='/'>All Classes (excluding platform)</a></b>");
        this.out.println("</p>");
        this.out.println("<table align=center border=1>");
        this.out.println("<tr><th><a href='/histo/class'>Class</a></th>");
        this.out.println("<th><a href='/histo/count'>Instance Count</a></th>");
        this.out.println("<th><a href='/histo/size'>Total Size</a></th></tr>");
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            this.out.println("<tr><td>");
            this.printClass(javaClass);
            this.out.println("</td>");
            this.out.println("<td>");
            this.out.println(javaClass.getInstancesCount(false));
            this.out.println("</td>");
            this.out.println("<td>");
            this.out.println(javaClass.getTotalInstanceSize());
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
        this.endHtml();
    }
}

