/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.ClassReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class AccessFlags {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MODULE = 32768;
    private static final int[] classModifiers = new int[]{1, 16, 1024, 32768};
    private static final int[] classFlags = new int[]{1, 16, 32, 512, 1024, 4096, 8192, 16384, 32768};
    private static final int[] innerClassModifiers = new int[]{1, 2, 4, 8, 16, 1024, 32768};
    private static final int[] innerClassFlags = new int[]{1, 2, 4, 8, 16, 32, 512, 1024, 4096, 8192, 16384, 32768};
    private static final int[] fieldModifiers = new int[]{1, 2, 4, 8, 16, 64, 128, 32768};
    private static final int[] fieldFlags = new int[]{1, 2, 4, 8, 16, 64, 128, 4096, 16384, 32768};
    private static final int[] methodModifiers = new int[]{1, 2, 4, 8, 16, 32, 256, 1024, 2048, 32768};
    private static final int[] methodFlags = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 1024, 2048, 4096, 32768};
    public final int flags;

    AccessFlags(ClassReader classReader) throws IOException {
        this(classReader.readUnsignedShort());
    }

    public AccessFlags(int n) {
        this.flags = n;
    }

    public AccessFlags ignore(int n) {
        return new AccessFlags(this.flags & ~n);
    }

    public boolean is(int n) {
        return (this.flags & n) != 0;
    }

    public int byteLength() {
        return 2;
    }

    public Set<String> getClassModifiers() {
        int n = (this.flags & 0x200) != 0 ? this.flags & 0xFFFFFBFF : this.flags;
        return AccessFlags.getModifiers(n, classModifiers, Kind.Class);
    }

    public Set<String> getClassFlags() {
        return this.getFlags(classFlags, Kind.Class);
    }

    public Set<String> getInnerClassModifiers() {
        int n = (this.flags & 0x200) != 0 ? this.flags & 0xFFFFFBFF : this.flags;
        return AccessFlags.getModifiers(n, innerClassModifiers, Kind.InnerClass);
    }

    public Set<String> getInnerClassFlags() {
        return this.getFlags(innerClassFlags, Kind.InnerClass);
    }

    public Set<String> getFieldModifiers() {
        return this.getModifiers(fieldModifiers, Kind.Field);
    }

    public Set<String> getFieldFlags() {
        return this.getFlags(fieldFlags, Kind.Field);
    }

    public Set<String> getMethodModifiers() {
        return this.getModifiers(methodModifiers, Kind.Method);
    }

    public Set<String> getMethodFlags() {
        return this.getFlags(methodFlags, Kind.Method);
    }

    private Set<String> getModifiers(int[] nArray, Kind kind) {
        return AccessFlags.getModifiers(this.flags, nArray, kind);
    }

    private static Set<String> getModifiers(int n, int[] nArray, Kind kind) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int n2 : nArray) {
            if ((n & n2) == 0) continue;
            linkedHashSet.add(AccessFlags.flagToModifier(n2, kind));
        }
        return linkedHashSet;
    }

    private Set<String> getFlags(int[] nArray, Kind kind) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = this.flags;
        for (int n2 : nArray) {
            if ((n & n2) == 0) continue;
            linkedHashSet.add(AccessFlags.flagToName(n2, kind));
            n &= ~n2;
        }
        while (n != 0) {
            int n3 = Integer.highestOneBit(n);
            linkedHashSet.add("0x" + Integer.toHexString(n3));
            n &= ~n3;
        }
        return linkedHashSet;
    }

    private static String flagToModifier(int n, Kind kind) {
        switch (n) {
            case 1: {
                return "public";
            }
            case 2: {
                return "private";
            }
            case 4: {
                return "protected";
            }
            case 8: {
                return "static";
            }
            case 16: {
                return "final";
            }
            case 32: {
                return "synchronized";
            }
            case 128: {
                return kind == Kind.Field ? "transient" : null;
            }
            case 64: {
                return "volatile";
            }
            case 256: {
                return "native";
            }
            case 1024: {
                return "abstract";
            }
            case 2048: {
                return "strictfp";
            }
            case 32768: {
                return "module";
            }
        }
        return null;
    }

    private static String flagToName(int n, Kind kind) {
        switch (n) {
            case 1: {
                return "ACC_PUBLIC";
            }
            case 2: {
                return "ACC_PRIVATE";
            }
            case 4: {
                return "ACC_PROTECTED";
            }
            case 8: {
                return "ACC_STATIC";
            }
            case 16: {
                return "ACC_FINAL";
            }
            case 32: {
                return kind == Kind.Class ? "ACC_SUPER" : "ACC_SYNCHRONIZED";
            }
            case 64: {
                return kind == Kind.Field ? "ACC_VOLATILE" : "ACC_BRIDGE";
            }
            case 128: {
                return kind == Kind.Field ? "ACC_TRANSIENT" : "ACC_VARARGS";
            }
            case 256: {
                return "ACC_NATIVE";
            }
            case 512: {
                return "ACC_INTERFACE";
            }
            case 1024: {
                return "ACC_ABSTRACT";
            }
            case 2048: {
                return "ACC_STRICT";
            }
            case 4096: {
                return "ACC_SYNTHETIC";
            }
            case 8192: {
                return "ACC_ANNOTATION";
            }
            case 16384: {
                return "ACC_ENUM";
            }
            case 32768: {
                return "ACC_MODULE";
            }
        }
        return null;
    }

    public static enum Kind {
        Class,
        InnerClass,
        Field,
        Method;

    }
}

