/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.qualframework.util.ExtendedArrayType;
import org.checkerframework.qualframework.util.ExtendedDeclaredType;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedIntersectionType;
import org.checkerframework.qualframework.util.ExtendedNoType;
import org.checkerframework.qualframework.util.ExtendedNullType;
import org.checkerframework.qualframework.util.ExtendedParameterDeclaration;
import org.checkerframework.qualframework.util.ExtendedPrimitiveType;
import org.checkerframework.qualframework.util.ExtendedReferenceType;
import org.checkerframework.qualframework.util.ExtendedTypeDeclaration;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.ExtendedTypeVariable;
import org.checkerframework.qualframework.util.ExtendedTypeVisitor;
import org.checkerframework.qualframework.util.ExtendedUnionType;
import org.checkerframework.qualframework.util.ExtendedWildcardType;

public abstract class WrappedAnnotatedTypeMirror
implements ExtendedTypeMirror {
    private final AnnotatedTypeMirror underlying;

    private WrappedAnnotatedTypeMirror(AnnotatedTypeMirror underlying) {
        if (underlying == null) {
            throw new IllegalArgumentException("underlying ATM must be non-null");
        }
        this.underlying = underlying;
    }

    public static WrappedAnnotatedTypeMirror wrap(AnnotatedTypeMirror atm) {
        return WrappedAnnotatedTypeMirror.wrapImpl(atm.deepCopy());
    }

    private static WrappedAnnotatedTypeMirror wrapImpl(AnnotatedTypeMirror atm) {
        if (atm == null) {
            return null;
        }
        switch (atm.getKind()) {
            case ARRAY: {
                return new WrappedAnnotatedArrayType((AnnotatedTypeMirror.AnnotatedArrayType)atm);
            }
            case DECLARED: {
                return new WrappedAnnotatedDeclaredType((AnnotatedTypeMirror.AnnotatedDeclaredType)atm);
            }
            case EXECUTABLE: {
                return new WrappedAnnotatedExecutableType((AnnotatedTypeMirror.AnnotatedExecutableType)atm);
            }
            case VOID: 
            case PACKAGE: 
            case NONE: {
                return new WrappedAnnotatedNoType((AnnotatedTypeMirror.AnnotatedNoType)atm);
            }
            case NULL: {
                return new WrappedAnnotatedNullType((AnnotatedTypeMirror.AnnotatedNullType)atm);
            }
            case TYPEVAR: {
                return new WrappedAnnotatedTypeVariable((AnnotatedTypeMirror.AnnotatedTypeVariable)atm);
            }
            case WILDCARD: {
                return new WrappedAnnotatedWildcardType((AnnotatedTypeMirror.AnnotatedWildcardType)atm);
            }
            case INTERSECTION: {
                return new WrappedAnnotatedIntersectionType((AnnotatedTypeMirror.AnnotatedIntersectionType)atm);
            }
            case UNION: {
                return new WrappedAnnotatedUnionType((AnnotatedTypeMirror.AnnotatedUnionType)atm);
            }
        }
        if (atm.getKind().isPrimitive()) {
            return new WrappedAnnotatedPrimitiveType((AnnotatedTypeMirror.AnnotatedPrimitiveType)atm);
        }
        throw new IllegalArgumentException("unexpected type kind: " + (Object)((Object)atm.getKind()));
    }

    private static List<WrappedAnnotatedTypeMirror> wrapList(List<? extends AnnotatedTypeMirror> atms) {
        ArrayList<WrappedAnnotatedTypeMirror> watms = new ArrayList<WrappedAnnotatedTypeMirror>();
        for (AnnotatedTypeMirror annotatedTypeMirror : atms) {
            watms.add(WrappedAnnotatedTypeMirror.wrapImpl(annotatedTypeMirror));
        }
        return watms;
    }

    private static List<WrappedAnnotatedTypeVariable> wrapTypeVarList(List<? extends AnnotatedTypeMirror.AnnotatedTypeVariable> atms) {
        ArrayList<WrappedAnnotatedTypeVariable> watms = new ArrayList<WrappedAnnotatedTypeVariable>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable : atms) {
            watms.add((WrappedAnnotatedTypeVariable)WrappedAnnotatedTypeMirror.wrapImpl(annotatedTypeVariable));
        }
        return watms;
    }

    public AnnotatedTypeMirror unwrap() {
        return this.underlying;
    }

    @Override
    public TypeMirror getOriginalType() {
        return this.underlying.getUnderlyingType();
    }

    @Override
    public TypeKind getKind() {
        return this.underlying.getKind();
    }

    @Override
    public boolean isDeclaration() {
        return this.underlying.isDeclaration();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        throw new UnsupportedOperationException("ATM doesn't support getAnnotation");
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        result.addAll(this.underlying.getAnnotations());
        return result;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        throw new UnsupportedOperationException("ATM doesn't support getAnnotationsByType");
    }

    public String toString() {
        return this.underlying.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WrappedAnnotatedTypeMirror other = (WrappedAnnotatedTypeMirror)obj;
        return this.underlying.equals(other.underlying);
    }

    public int hashCode() {
        return this.underlying.hashCode();
    }

    public static class WrappedAnnotatedWildcardType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedWildcardType {
        private final WrappedAnnotatedTypeMirror extendsBound;
        private final WrappedAnnotatedTypeMirror superBound;

        private WrappedAnnotatedWildcardType(AnnotatedTypeMirror.AnnotatedWildcardType underlying) {
            super(underlying);
            this.extendsBound = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getExtendsBound());
            this.superBound = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getSuperBound());
        }

        @Override
        public WildcardType getOriginalType() {
            return (WildcardType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedWildcardType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedWildcardType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public WrappedAnnotatedTypeMirror getExtendsBound() {
            return this.extendsBound;
        }

        @Override
        public WrappedAnnotatedTypeMirror getSuperBound() {
            return this.superBound;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            WrappedAnnotatedWildcardType other = (WrappedAnnotatedWildcardType)obj;
            return (this.extendsBound == null ? other.extendsBound == null : this.extendsBound.equals(other.extendsBound)) && (this.superBound == null ? other.superBound == null : this.superBound.equals(other.superBound));
        }
    }

    public static class WrappedAnnotatedUnionType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedUnionType {
        private final List<? extends WrappedAnnotatedTypeMirror> alternatives;

        private WrappedAnnotatedUnionType(AnnotatedTypeMirror.AnnotatedUnionType underlying) {
            super(underlying);
            this.alternatives = WrappedAnnotatedTypeMirror.wrapList(underlying.getAlternatives());
        }

        @Override
        public UnionType getOriginalType() {
            return (UnionType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedUnionType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedUnionType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }

        public List<? extends WrappedAnnotatedTypeMirror> getAlternatives() {
            return this.alternatives;
        }
    }

    public static class WrappedAnnotatedTypeVariable
    extends WrappedAnnotatedReferenceType
    implements ExtendedTypeVariable,
    ExtendedParameterDeclaration {
        private WrappedAnnotatedTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable underlying) {
            super(underlying);
        }

        @Override
        public TypeVariable getOriginalType() {
            return (TypeVariable)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedTypeVariable unwrap() {
            return (AnnotatedTypeMirror.AnnotatedTypeVariable)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            if (this.isDeclaration()) {
                return v.visitParameterDeclaration(this, p);
            }
            return v.visitTypeVariable(this, p);
        }

        @Override
        public Element asElement() {
            return this.getOriginalType().asElement();
        }

        @Override
        public ExtendedParameterDeclaration getDeclaration() {
            AnnotatedTypeMirror.AnnotatedTypeVariable copy = this.unwrap().deepCopy();
            copy.clearAnnotations();
            copy.setDeclaration(true);
            return (ExtendedParameterDeclaration)((Object)WrappedAnnotatedTypeVariable.wrap(copy));
        }
    }

    static abstract class WrappedAnnotatedReferenceType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedReferenceType {
        private WrappedAnnotatedReferenceType(AnnotatedTypeMirror underlying) {
            super(underlying);
        }
    }

    public static class WrappedAnnotatedPrimitiveType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedPrimitiveType {
        private WrappedAnnotatedPrimitiveType(AnnotatedTypeMirror.AnnotatedPrimitiveType underlying) {
            super(underlying);
        }

        @Override
        public PrimitiveType getOriginalType() {
            return (PrimitiveType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedPrimitiveType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedPrimitiveType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }
    }

    public static class WrappedAnnotatedNullType
    extends WrappedAnnotatedReferenceType
    implements ExtendedNullType {
        private WrappedAnnotatedNullType(AnnotatedTypeMirror.AnnotatedNullType underlying) {
            super(underlying);
        }

        @Override
        public NullType getOriginalType() {
            return (NullType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedNullType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedNullType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }
    }

    public static class WrappedAnnotatedNoType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedNoType {
        private WrappedAnnotatedNoType(AnnotatedTypeMirror.AnnotatedNoType underlying) {
            super(underlying);
        }

        @Override
        public NoType getOriginalType() {
            return (NoType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedNoType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedNoType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }

    public static class WrappedAnnotatedIntersectionType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedIntersectionType {
        private final List<? extends WrappedAnnotatedTypeMirror> bounds;

        private WrappedAnnotatedIntersectionType(AnnotatedTypeMirror.AnnotatedIntersectionType underlying) {
            super(underlying);
            this.bounds = WrappedAnnotatedTypeMirror.wrapList(underlying.directSuperTypes());
        }

        @Override
        public IntersectionType getOriginalType() {
            return (IntersectionType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedIntersectionType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedIntersectionType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }

        public List<? extends WrappedAnnotatedTypeMirror> getBounds() {
            return this.bounds;
        }
    }

    public static class WrappedAnnotatedExecutableType
    extends WrappedAnnotatedTypeMirror
    implements ExtendedExecutableType {
        private final List<? extends WrappedAnnotatedTypeMirror> parameterTypes;
        private final WrappedAnnotatedTypeMirror receiverType;
        private final WrappedAnnotatedTypeMirror returnType;
        private final List<? extends WrappedAnnotatedTypeMirror> thrownTypes;
        private final List<? extends WrappedAnnotatedTypeVariable> typeParameters;

        private WrappedAnnotatedExecutableType(AnnotatedTypeMirror.AnnotatedExecutableType underlying) {
            super(underlying);
            this.parameterTypes = WrappedAnnotatedTypeMirror.wrapList(underlying.getParameterTypes());
            this.receiverType = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getReceiverType());
            this.returnType = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getReturnType());
            this.thrownTypes = WrappedAnnotatedTypeMirror.wrapList(underlying.getThrownTypes());
            this.typeParameters = WrappedAnnotatedTypeMirror.wrapTypeVarList(underlying.getTypeVariables());
        }

        @Override
        public ExecutableType getOriginalType() {
            return (ExecutableType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedExecutableType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedExecutableType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public ExecutableElement asElement() {
            return this.unwrap().getElement();
        }

        @Override
        public List<? extends ExtendedTypeMirror> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public WrappedAnnotatedTypeMirror getReceiverType() {
            return this.receiverType;
        }

        @Override
        public WrappedAnnotatedTypeMirror getReturnType() {
            return this.returnType;
        }

        public List<? extends WrappedAnnotatedTypeMirror> getThrownTypes() {
            return this.thrownTypes;
        }

        public List<? extends WrappedAnnotatedTypeVariable> getTypeParameters() {
            return this.typeParameters;
        }
    }

    public static class WrappedAnnotatedDeclaredType
    extends WrappedAnnotatedReferenceType
    implements ExtendedDeclaredType,
    ExtendedTypeDeclaration {
        private final WrappedAnnotatedTypeMirror enclosingType;
        private final List<WrappedAnnotatedTypeMirror> typeArguments;

        private WrappedAnnotatedDeclaredType(AnnotatedTypeMirror.AnnotatedDeclaredType underlying) {
            super(underlying);
            this.enclosingType = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getEnclosingType());
            this.typeArguments = WrappedAnnotatedTypeMirror.wrapList(underlying.getTypeArguments());
        }

        @Override
        public DeclaredType getOriginalType() {
            return (DeclaredType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedDeclaredType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedDeclaredType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            if (this.isDeclaration()) {
                return v.visitTypeDeclaration(this, p);
            }
            return v.visitDeclared(this, p);
        }

        @Override
        public Element asElement() {
            return this.getOriginalType().asElement();
        }

        @Override
        public WrappedAnnotatedTypeMirror getEnclosingType() {
            return this.enclosingType;
        }

        public List<? extends WrappedAnnotatedTypeMirror> getTypeArguments() {
            return this.typeArguments;
        }

        public List<? extends WrappedAnnotatedTypeVariable> getTypeParameters() {
            return this.typeArguments;
        }
    }

    public static class WrappedAnnotatedArrayType
    extends WrappedAnnotatedReferenceType
    implements ExtendedArrayType {
        private final WrappedAnnotatedTypeMirror componentType;

        private WrappedAnnotatedArrayType(AnnotatedTypeMirror.AnnotatedArrayType underlying) {
            super(underlying);
            this.componentType = WrappedAnnotatedTypeMirror.wrapImpl(underlying.getComponentType());
        }

        @Override
        public ArrayType getOriginalType() {
            return (ArrayType)super.getOriginalType();
        }

        @Override
        public AnnotatedTypeMirror.AnnotatedArrayType unwrap() {
            return (AnnotatedTypeMirror.AnnotatedArrayType)super.unwrap();
        }

        @Override
        public <R, P> R accept(ExtendedTypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        public WrappedAnnotatedTypeMirror getComponentType() {
            return this.componentType;
        }
    }
}

