/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.qualframework.poly.CombiningOperation;
import org.checkerframework.qualframework.poly.PolyQual;

public class Wildcard<Q> {
    private final PolyQual<Q> lower;
    private final PolyQual<Q> upper;

    public Wildcard(PolyQual<Q> lower, PolyQual<Q> upper) {
        if (lower == null || upper == null) {
            throw new IllegalArgumentException("wildcard bounds may not be null");
        }
        this.lower = lower;
        this.upper = upper;
    }

    public Wildcard(PolyQual<Q> qual) {
        this(qual, qual);
    }

    public Wildcard(Q groundLower, Q groundUpper) {
        this(new PolyQual.GroundQual<Q>(groundLower), new PolyQual.GroundQual<Q>(groundUpper));
    }

    public Wildcard(Q groundQual) {
        this(new PolyQual.GroundQual<Q>(groundQual));
    }

    private Wildcard() {
        this.lower = null;
        this.upper = null;
    }

    public static <Q> Wildcard<Q> empty() {
        return new Wildcard<Q>();
    }

    public PolyQual<Q> getLowerBound() {
        return this.lower;
    }

    public PolyQual<Q> getUpperBound() {
        return this.upper;
    }

    public boolean isEmpty() {
        return this.lower == null;
    }

    public Wildcard<Q> substitute(Map<String, Wildcard<Q>> substs) {
        HashMap lowerSubsts = new HashMap();
        HashMap upperSubsts = new HashMap();
        for (String k : substs.keySet()) {
            lowerSubsts.put(k, substs.get(k).getLowerBound());
            upperSubsts.put(k, substs.get(k).getUpperBound());
        }
        PolyQual<Q> newLower = this.lower.substitute(lowerSubsts);
        PolyQual<Q> newUpper = this.upper.substitute(upperSubsts);
        return new Wildcard<PolyQual<Q>>(newLower, newUpper);
    }

    public Wildcard<Q> combineWith(Wildcard<Q> other, CombiningOperation<Q> lowerOp, CombiningOperation<Q> upperOp) {
        return new Wildcard<PolyQual<Q>>(this.getLowerBound().combineWith(other.getLowerBound(), lowerOp), this.getUpperBound().combineWith(other.getUpperBound(), upperOp));
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Wildcard other = (Wildcard)o;
        return this.lower.equals(other.lower) && this.upper.equals(other.upper);
    }

    public int hashCode() {
        return this.lower.hashCode() * 37 + this.upper.hashCode() * 59;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "\u00f8";
        }
        if (this.lower.equals(this.upper)) {
            return this.lower.toString();
        }
        return "? \u2208 [" + this.lower + ".." + this.upper + "]";
    }
}

