/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.typeinference.solver.TargetConstraints;

public class ConstraintMap {
    private final Map<TypeVariable, TargetConstraints> targetToRecords = new LinkedHashMap<TypeVariable, TargetConstraints>();

    public ConstraintMap(Set<TypeVariable> targets) {
        for (TypeVariable target : targets) {
            this.targetToRecords.put(target, new TargetConstraints(target));
        }
    }

    public ConstraintMap(ConstraintMap toCopy) {
        this.targetToRecords.putAll(toCopy.targetToRecords);
    }

    public TargetConstraints getConstraints(TypeVariable target) {
        return this.targetToRecords.get(target);
    }

    public Set<TypeVariable> getTargets() {
        return this.targetToRecords.keySet();
    }

    public void addTargetEquality(TypeVariable target, TypeVariable equivalent, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Equalities equalities = this.targetToRecords.get((Object)target).equalities;
        Set<AnnotationMirror> equivalentTops = equalities.targets.get(equivalent);
        if (equivalentTops == null) {
            equalities.targets.put(equivalent, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            equivalentTops.addAll(hierarchies);
        }
    }

    public void addPrimaryEqualities(TypeVariable target, QualifierHierarchy qualHierarchy, Set<AnnotationMirror> annos) {
        TargetConstraints.Equalities equalities = this.targetToRecords.get((Object)target).equalities;
        for (AnnotationMirror anno : annos) {
            AnnotationMirror top = qualHierarchy.getTopAnnotation(anno);
            if (equalities.primaries.containsKey(top)) continue;
            equalities.primaries.put(top, anno);
        }
    }

    public void addTargetSupertype(TypeVariable target, TypeVariable subtype, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Supertypes supertypes = this.targetToRecords.get((Object)target).supertypes;
        Set<AnnotationMirror> supertypeTops = supertypes.targets.get(subtype);
        if (supertypeTops == null) {
            supertypes.targets.put(subtype, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            supertypeTops.addAll(hierarchies);
        }
    }

    public void addTypeSupertype(TypeVariable target, AnnotatedTypeMirror subtype, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Supertypes supertypes = this.targetToRecords.get((Object)target).supertypes;
        Set<AnnotationMirror> supertypeTops = supertypes.types.get(subtype);
        if (supertypeTops == null) {
            supertypes.types.put(subtype, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            supertypeTops.addAll(hierarchies);
        }
    }

    public void addPrimarySupertype(TypeVariable target, QualifierHierarchy qualifierHierarchy, Set<AnnotationMirror> annos) {
        TargetConstraints.Supertypes supertypes = this.targetToRecords.get((Object)target).supertypes;
        for (AnnotationMirror anno : annos) {
            AnnotationMirror top = qualifierHierarchy.getTopAnnotation(anno);
            Set<AnnotationMirror> entries = supertypes.primaries.get(top);
            if (entries == null) {
                entries = new LinkedHashSet<AnnotationMirror>();
                supertypes.primaries.put(top, entries);
            }
            entries.add(anno);
        }
    }

    public void addTargetSubtype(TypeVariable target, TypeVariable supertype, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Subtypes subtypes = this.targetToRecords.get((Object)target).subtypes;
        Set<AnnotationMirror> subtypesTops = subtypes.targets.get(supertype);
        if (subtypesTops == null) {
            subtypes.targets.put(supertype, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            subtypesTops.addAll(hierarchies);
        }
    }

    public void addTypeSubtype(TypeVariable target, AnnotatedTypeMirror supertype, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Subtypes subtypes = this.targetToRecords.get((Object)target).subtypes;
        Set<AnnotationMirror> subtypesTops = subtypes.targets.get(supertype);
        if (subtypesTops == null) {
            subtypes.types.put(supertype, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            subtypesTops.addAll(hierarchies);
        }
    }

    public void addPrimarySubtypes(TypeVariable target, QualifierHierarchy qualifierHierarchy, Set<AnnotationMirror> annos) {
        TargetConstraints.Subtypes subtypes = this.targetToRecords.get((Object)target).subtypes;
        for (AnnotationMirror anno : annos) {
            AnnotationMirror top = qualifierHierarchy.getTopAnnotation(anno);
            Set<AnnotationMirror> entries = subtypes.primaries.get(top);
            if (entries == null) {
                entries = new LinkedHashSet<AnnotationMirror>();
                subtypes.primaries.put(top, entries);
            }
            entries.add(anno);
        }
    }

    public void addTypeEqualities(TypeVariable target, AnnotatedTypeMirror type, Set<AnnotationMirror> hierarchies) {
        TargetConstraints.Equalities equalities = this.targetToRecords.get((Object)target).equalities;
        Set<AnnotationMirror> equalityTops = equalities.types.get(type);
        if (equalityTops == null) {
            equalities.types.put(type, new HashSet<AnnotationMirror>(hierarchies));
        } else {
            equalityTops.addAll(hierarchies);
        }
    }
}

