/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.checker.experimental.regex_qual.RegexQualifierHierarchy;
import org.checkerframework.checker.regex.RegexAnnotationConverter;
import org.checkerframework.checker.regex.RegexQualifiedTransfer;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.SetQualifierVisitor;
import org.checkerframework.qualframework.base.TypeVariableSubstitutor;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.poly.CombiningOperation;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifiedParameterTypeVariableSubstitutor;
import org.checkerframework.qualframework.poly.QualifierParameterTreeAnnotator;
import org.checkerframework.qualframework.poly.QualifierParameterTypeFactory;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class RegexQualifiedTypeFactory
extends QualifierParameterTypeFactory<org.checkerframework.checker.experimental.regex_qual.Regex> {
    private final CombiningOperation<org.checkerframework.checker.experimental.regex_qual.Regex> lubOp = new CombiningOperation.Lub<org.checkerframework.checker.experimental.regex_qual.Regex>(new RegexQualifierHierarchy());
    private final ExecutableElement patternCompile = TreeUtils.getMethod("java.util.regex.Pattern", "compile", 1, this.getContext().getProcessingEnvironment());

    public RegexQualifiedTypeFactory(QualifierContext<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> checker) {
        super(checker);
    }

    @Override
    protected QualifierHierarchy<org.checkerframework.checker.experimental.regex_qual.Regex> createGroundQualifierHierarchy() {
        return new RegexQualifierHierarchy();
    }

    @Override
    protected RegexAnnotationConverter createAnnotationConverter() {
        return new RegexAnnotationConverter();
    }

    @Override
    protected QualifierParameterTreeAnnotator<org.checkerframework.checker.experimental.regex_qual.Regex> createTreeAnnotator() {
        return new QualifierParameterTreeAnnotator<org.checkerframework.checker.experimental.regex_qual.Regex>((QualifierParameterTypeFactory)this){

            @Override
            public QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> visitLiteral(LiteralTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Object> result = super.visitLiteral(tree, type);
                if (tree.getKind() == Tree.Kind.NULL_LITERAL) {
                    return SetQualifierVisitor.apply(result, RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom());
                }
                String regexStr = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    regexStr = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    regexStr = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (regexStr != null) {
                    org.checkerframework.checker.experimental.regex_qual.Regex regexQual;
                    if (RegexQualifiedTypeFactory.isRegex(regexStr)) {
                        int groupCount = RegexQualifiedTypeFactory.getGroupCount(regexStr);
                        regexQual = new Regex.RegexVal(groupCount);
                    } else {
                        regexQual = new Regex.PartialRegex(regexStr);
                    }
                    Object clone = result.getQualifier().clone();
                    ((QualParams)clone).setPrimary(new PolyQual.GroundQual<Regex.PartialRegex>((Regex.PartialRegex)regexQual));
                    result = SetQualifierVisitor.apply(result, clone);
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> visitCompoundAssignment(CompoundAssignmentTree tree, ExtendedTypeMirror type) {
                QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> rRegex;
                QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> lRegex;
                QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> result;
                if ((TreeUtils.isStringConcatenation(tree) || TreeUtils.isStringCompoundConcatenation(tree)) && (result = this.handleBinaryOperation(tree, lRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getExpression())), rRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getVariable())), type)) != null) {
                    return result;
                }
                return super.visitCompoundAssignment(tree, type);
            }

            @Override
            public QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> visitMethodInvocation(MethodInvocationTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Object> result = super.visitMethodInvocation(tree, type);
                if (TreeUtils.isMethodInvocation(tree, RegexQualifiedTypeFactory.this.patternCompile, RegexQualifiedTypeFactory.this.getContext().getProcessingEnvironment())) {
                    ExpressionTree arg0 = tree.getArguments().get(0);
                    if (RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(arg0)) == RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom()) {
                        result = SetQualifierVisitor.apply(result, RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom());
                    } else {
                        org.checkerframework.checker.experimental.regex_qual.Regex qual = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(arg0)).getPrimary().getMaximum();
                        Object clone = result.getQualifier().clone();
                        ((QualParams)clone).setPrimary(new PolyQual.GroundQual<org.checkerframework.checker.experimental.regex_qual.Regex>(qual));
                        result = SetQualifierVisitor.apply(result, clone);
                    }
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> visitBinary(BinaryTree tree, ExtendedTypeMirror type) {
                QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> rRegex;
                QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> lRegex;
                QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> result;
                if ((TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation((CompoundAssignmentTree)((Object)tree))) && (result = this.handleBinaryOperation(tree, lRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getLeftOperand())), rRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getRightOperand())), type)) != null) {
                    return result;
                }
                return super.visitBinary(tree, type);
            }

            private QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> handleBinaryOperation(Tree tree, QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> lRegexParam, QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> rRegexParam, ExtendedTypeMirror type) {
                if (TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation((CompoundAssignmentTree)tree)) {
                    PolyQual.GroundQual<org.checkerframework.checker.experimental.regex_qual.Regex> resultQual = null;
                    PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> rPrimary = rRegexParam.getPrimary();
                    PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> lPrimary = lRegexParam.getPrimary();
                    org.checkerframework.checker.experimental.regex_qual.Regex rRegex = RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom() == rRegexParam ? new Regex.RegexVal(0) : rPrimary.getMaximum();
                    org.checkerframework.checker.experimental.regex_qual.Regex lRegex = RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom() == lRegexParam ? new Regex.RegexVal(0) : lPrimary.getMaximum();
                    PolyQual.GroundQual<org.checkerframework.checker.experimental.regex_qual.Regex> polyResult = RegexQualifiedTypeFactory.this.checkPoly(lPrimary, rPrimary, lRegex, rRegex);
                    if (polyResult != null) {
                        resultQual = polyResult;
                    } else if (lRegex.isRegexVal() && rRegex.isRegexVal()) {
                        int resultCount = ((Regex.RegexVal)lRegex).getCount() + ((Regex.RegexVal)rRegex).getCount();
                        resultQual = new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(resultCount));
                    } else if (lRegex.isPartialRegex() && rRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + ((Regex.PartialRegex)rRegex).getPartialValue();
                        if (RegexQualifiedTypeFactory.isRegex(concat)) {
                            int groupCount = RegexQualifiedTypeFactory.getGroupCount(concat);
                            resultQual = new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(groupCount));
                        } else {
                            resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                        }
                    } else if (lRegex.isRegexVal() && rRegex.isPartialRegex()) {
                        String concat = "e" + ((Regex.PartialRegex)rRegex).getPartialValue();
                        resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                    } else if (rRegex.isRegexVal() && lRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + "e";
                        resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                    } else if (rRegex == org.checkerframework.checker.experimental.regex_qual.Regex.TOP || lRegex == org.checkerframework.checker.experimental.regex_qual.Regex.TOP) {
                        resultQual = new PolyQual.GroundQual<org.checkerframework.checker.experimental.regex_qual.Regex>(org.checkerframework.checker.experimental.regex_qual.Regex.TOP);
                    } else if (rRegex == org.checkerframework.checker.experimental.regex_qual.Regex.BOTTOM && lRegex == org.checkerframework.checker.experimental.regex_qual.Regex.BOTTOM) {
                        resultQual = new PolyQual.GroundQual<org.checkerframework.checker.experimental.regex_qual.Regex>(org.checkerframework.checker.experimental.regex_qual.Regex.BOTTOM);
                    }
                    if (resultQual != null) {
                        return new QualifiedTypeMirror.QualifiedDeclaredType<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>>(type, new QualParams(resultQual), new ArrayList());
                    }
                }
                return null;
            }
        };
    }

    private PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> checkPoly(PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> lPrimary, PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> rPrimary, org.checkerframework.checker.experimental.regex_qual.Regex lRegex, org.checkerframework.checker.experimental.regex_qual.Regex rRegex) {
        if (this.isPolyRegex(lPrimary) && this.isPolyRegex(rPrimary)) {
            return lPrimary;
        }
        if (this.isPolyRegex(lPrimary) && rRegex.isRegexVal()) {
            return lPrimary;
        }
        if (this.isPolyRegex(rPrimary) && lRegex.isRegexVal()) {
            return rPrimary;
        }
        return null;
    }

    private boolean isPolyRegex(PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> possiblePoly) {
        return possiblePoly instanceof PolyQual.QualVar && ((PolyQual.QualVar)possiblePoly).getName().equals("_poly");
    }

    public static int getGroupCount(@Regex String regex) {
        return Pattern.compile(regex).matcher("").groupCount();
    }

    @Pure
    private static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public QualAnalysis<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> createFlowAnalysis(List<Pair<VariableElement, QualValue<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>>>> fieldValues) {
        return new QualAnalysis<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>>(this.getContext()){

            @Override
            public QualTransfer<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> createTransferFunction() {
                return new RegexQualifiedTransfer(this);
            }
        };
    }

    @Override
    public TypeVariableSubstitutor<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> createTypeVariableSubstitutor() {
        return new QualifiedParameterTypeVariableSubstitutor<org.checkerframework.checker.experimental.regex_qual.Regex>(){

            @Override
            protected Wildcard<org.checkerframework.checker.experimental.regex_qual.Regex> combineForSubstitution(Wildcard<org.checkerframework.checker.experimental.regex_qual.Regex> a, Wildcard<org.checkerframework.checker.experimental.regex_qual.Regex> b) {
                return a.combineWith(b, RegexQualifiedTypeFactory.this.lubOp, RegexQualifiedTypeFactory.this.lubOp);
            }

            @Override
            protected PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> combineForSubstitution(PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> a, PolyQual<org.checkerframework.checker.experimental.regex_qual.Regex> b) {
                return a.combineWith(b, RegexQualifiedTypeFactory.this.lubOp);
            }
        };
    }

    public QualParams<org.checkerframework.checker.experimental.regex_qual.Regex> getEffectiveQualifier(QualifiedTypeMirror<QualParams<org.checkerframework.checker.experimental.regex_qual.Regex>> mirror) {
        switch (mirror.getKind()) {
            case TYPEVAR: {
                return (QualParams)this.getQualifiedTypeParameterBounds(((QualifiedTypeMirror.QualifiedTypeVariable)mirror).getDeclaration().getUnderlyingType()).getUpperBound().getQualifier();
            }
            case WILDCARD: {
                return (QualParams)((QualifiedTypeMirror.QualifiedWildcardType)mirror).getExtendsBound().getQualifier();
            }
        }
        return mirror.getQualifier();
    }
}

