/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProxyOutputStream
extends FilterOutputStream {
    public ProxyOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream proxy) {
        super(proxy);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int idx) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(1);
            this.out.write(idx);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bts) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(bts);
            this.beforeWrite(len);
            this.out.write(bts);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bts, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(end);
            this.out.write(bts, st, end);
            this.afterWrite(end);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    protected void beforeWrite(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void afterWrite(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw e;
    }
}

