/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CHUNK_SIZE = 4096;
    private final @UnknownKeyFor @NonNull @Initialized int chunkSize;

    public ChunkedOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream stream, @UnknownKeyFor @NonNull @Initialized int chunkSize) {
        super(stream);
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
    }

    public ChunkedOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream stream) {
        this(stream, 4096);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int srcOffset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int bytes = length;
        int dstOffset = srcOffset;
        while (bytes > 0) {
            int chunk = Math.min(bytes, this.chunkSize);
            this.out.write(data, dstOffset, chunk);
            bytes -= chunk;
            dstOffset += chunk;
        }
    }
}

