/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(@UnknownKeyFor @NonNull @Initialized int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.writeImpl(b, off, len);
        }
    }

    @Override
    public synchronized void write(@UnknownKeyFor @NonNull @Initialized int b) {
        this.writeImpl(b);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.writeImpl(in);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized int size() {
        return this.count;
    }

    @Override
    public synchronized void reset() {
        this.resetImpl();
    }

    @Override
    public synchronized void writeTo(@UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.writeToImpl(out);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input, 1024);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(size);){
            output.write(input);
            InputStream inputStream = output.toInputStream();
            return inputStream;
        }
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized InputStream toInputStream() {
        return this.toInputStream(ByteArrayInputStream::new);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray() {
        return this.toByteArrayImpl();
    }
}

