/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.input.ObservableInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MessageDigestCalculatingInputStream
extends ObservableInputStream {
    private final @UnknownKeyFor @NonNull @Initialized MessageDigest messageDigest;

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized MessageDigest MessageDigest2) {
        super(inputStream);
        this.messageDigest = MessageDigest2;
        this.add(new MessageDigestMaintainingObserver(MessageDigest2));
    }

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized String algorithm) throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException {
        this(inputStream, MessageDigest.getInstance(algorithm));
    }

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException {
        this(inputStream, MessageDigest.getInstance("MD5"));
    }

    public @UnknownKeyFor @NonNull @Initialized MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public static class MessageDigestMaintainingObserver
    extends ObservableInputStream.Observer {
        private final @UnknownKeyFor @NonNull @Initialized MessageDigest messageDigest;

        public MessageDigestMaintainingObserver(@UnknownKeyFor @NonNull @Initialized MessageDigest messageDigest) {
            this.messageDigest = messageDigest;
        }

        @Override
        public void data(@UnknownKeyFor @NonNull @Initialized int input) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.messageDigest.update((byte)input);
        }

        @Override
        public void data(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.messageDigest.update(input, offset, length);
        }
    }
}

