/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@FunctionalInterface
public interface IOFunction<@UnknownKeyFor T, @UnknownKeyFor R> {
    public R apply(T var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    default public <V> @UnknownKeyFor @NonNull @Initialized IOFunction<V, R> compose(@UnknownKeyFor @NonNull @Initialized IOFunction<@UnknownKeyFor @Nullable @Initialized ? super V, @UnknownKeyFor @NonNull @Initialized ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> @UnknownKeyFor @NonNull @Initialized IOFunction<V, R> compose(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @Nullable @Initialized ? super V, @KeyForBottom @NonNull @Initialized ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public @UnknownKeyFor @NonNull @Initialized IOSupplier<R> compose(@UnknownKeyFor @NonNull @Initialized IOSupplier<@UnknownKeyFor @NonNull @Initialized ? extends T> before) {
        Objects.requireNonNull(before);
        return () -> this.apply(before.get());
    }

    default public @UnknownKeyFor @NonNull @Initialized IOSupplier<R> compose(@UnknownKeyFor @NonNull @Initialized Supplier<@KeyForBottom @NonNull @Initialized ? extends T> before) {
        Objects.requireNonNull(before);
        return () -> this.apply(before.get());
    }

    default public <V> @UnknownKeyFor @NonNull @Initialized IOFunction<T, V> andThen(@UnknownKeyFor @NonNull @Initialized IOFunction<@UnknownKeyFor @Nullable @Initialized ? super R, @UnknownKeyFor @NonNull @Initialized ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public <V> @UnknownKeyFor @NonNull @Initialized IOFunction<T, V> andThen(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @Nullable @Initialized ? super R, @KeyForBottom @NonNull @Initialized ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public @UnknownKeyFor @NonNull @Initialized IOConsumer<T> andThen(@UnknownKeyFor @NonNull @Initialized IOConsumer<@UnknownKeyFor @Nullable @Initialized ? super R> after) {
        Objects.requireNonNull(after);
        return t -> after.accept((R)this.apply(t));
    }

    default public @UnknownKeyFor @NonNull @Initialized IOConsumer<T> andThen(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @Nullable @Initialized ? super R> after) {
        Objects.requireNonNull(after);
        return t -> after.accept((R)this.apply(t));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IOFunction<T, T> identity() {
        return t -> t;
    }
}

