/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SizeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 7388077430788600069L;
    private final @UnknownKeyFor @NonNull @Initialized long size;
    private final @UnknownKeyFor @NonNull @Initialized boolean acceptLarger;

    public SizeFileFilter(@UnknownKeyFor @NonNull @Initialized long size) {
        this(size, true);
    }

    public SizeFileFilter(@UnknownKeyFor @NonNull @Initialized long size, @UnknownKeyFor @NonNull @Initialized boolean acceptLarger) {
        if (size < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = size;
        this.acceptLarger = acceptLarger;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File file) {
        return this.acceptLarger != file.length() < this.size;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String condition = this.acceptLarger ? ">=" : "<";
        return super.toString() + "(" + condition + this.size + ")";
    }
}

