/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.SimplePathVisitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CountingPathVisitor
extends SimplePathVisitor {
    static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] EMPTY_STRING_ARRAY = new String[0];
    private final @UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounters;

    public static @UnknownKeyFor @NonNull @Initialized CountingPathVisitor withBigIntegerCounters() {
        return new CountingPathVisitor(Counters.bigIntegerPathCounters());
    }

    public static @UnknownKeyFor @NonNull @Initialized CountingPathVisitor withLongCounters() {
        return new CountingPathVisitor(Counters.longPathCounters());
    }

    public CountingPathVisitor(@UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounter) {
        this.pathCounters = Objects.requireNonNull(pathCounter, "pathCounter");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CountingPathVisitor)) {
            return false;
        }
        CountingPathVisitor other = (CountingPathVisitor)obj;
        return Objects.equals(this.pathCounters, other.pathCounters);
    }

    public @UnknownKeyFor @NonNull @Initialized Counters.PathCounters getPathCounters() {
        return this.pathCounters;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pathCounters);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult postVisitDirectory(@UnknownKeyFor @NonNull @Initialized Path dir, @UnknownKeyFor @NonNull @Initialized IOException exc) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pathCounters.getDirectoryCounter().increment();
        return FileVisitResult.CONTINUE;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.pathCounters.toString();
    }

    protected void updateFileCounters(@UnknownKeyFor @NonNull @Initialized Path file, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) {
        this.pathCounters.getFileCounter().increment();
        this.pathCounters.getByteCounter().add(attributes.size());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult visitFile(@UnknownKeyFor @NonNull @Initialized Path file, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (Files.exists(file, new LinkOption[0])) {
            this.updateFileCounters(file, attributes);
        }
        return FileVisitResult.CONTINUE;
    }
}

