/*
 * Decompiled with CFR 0.152.
 */
package org.chartistjsf.model.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.chartistjsf.model.chart.AspectRatio;

public class ChartModel
implements Serializable {
    private static final long serialVersionUID = -8649635660286079308L;
    private List<Object> labels;
    private String width;
    private String height;
    private String chartPadding = "5";
    private boolean reverseData = false;
    private AspectRatio aspectRatio;
    private boolean showTooltip = false;
    private String responsiveOptions;
    private boolean animateAdvanced = false;
    private boolean animatePath = false;

    public ChartModel() {
        this.labels = new ArrayList<Object>();
        this.aspectRatio = AspectRatio.GOLDEN_SECTION;
    }

    protected ChartModel(ChartModel chartModel) {
        this.labels = chartModel.labels;
        this.width = chartModel.width;
        this.height = chartModel.height;
        this.chartPadding = chartModel.chartPadding;
        this.reverseData = chartModel.reverseData;
        this.aspectRatio = chartModel.aspectRatio;
        this.showTooltip = chartModel.showTooltip;
        this.responsiveOptions = chartModel.responsiveOptions;
        this.animateAdvanced = chartModel.animateAdvanced;
        this.animatePath = chartModel.animatePath;
    }

    public List<Object> getLabels() {
        return this.labels;
    }

    public void addLabel(Object label) {
        this.labels.add(label);
    }

    public void clearLabels() {
        this.labels.clear();
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getChartPadding() {
        return this.chartPadding;
    }

    public void setChartPadding(String chartPadding) {
        this.chartPadding = chartPadding;
    }

    public boolean isReverseData() {
        return this.reverseData;
    }

    public void setReverseData(boolean reverseData) {
        this.reverseData = reverseData;
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public String getStyleClass() {
        return "ct-chart " + this.getAspectRatio().styleClass();
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public void setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
    }

    public String getResponsiveOptions() {
        return this.responsiveOptions;
    }

    public void setResponsiveOptions(String responsiveOptions) {
        this.responsiveOptions = responsiveOptions;
    }

    public boolean isAnimateAdvanced() {
        return this.animateAdvanced;
    }

    public void setAnimateAdvanced(boolean animateAdvanced) {
        this.animateAdvanced = animateAdvanced;
    }

    public boolean isAnimatePath() {
        return this.animatePath;
    }

    public void setAnimatePath(boolean animatePath) {
        this.animatePath = animatePath;
    }
}

