/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class SignalDto {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;

    public SignalDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the signal to deliver.  **Note**: This property is mandatory.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SignalDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optionally specifies a single execution which is notified by the signal.  **Note**: If no execution id is defined the signal is broadcasted to all subscribed handlers. ")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public SignalDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public SignalDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public SignalDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies a tenant to deliver the signal. The signal can only be received on executions or process definitions which belongs to the given tenant.  **Note**: Cannot be used in combination with executionId.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public SignalDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true the signal can only be received on executions or process definitions which belongs to no tenant. Value may not be false as this is the default behavior.  **Note**: Cannot be used in combination with `executionId`.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalDto signalDto = (SignalDto)o;
        return Objects.equals(this.name, signalDto.name) && Objects.equals(this.executionId, signalDto.executionId) && Objects.equals(this.variables, signalDto.variables) && Objects.equals(this.tenantId, signalDto.tenantId) && Objects.equals(this.withoutTenantId, signalDto.withoutTenantId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.executionId, this.variables, this.tenantId, this.withoutTenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalDto {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

