/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MigrationPlanDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;

public class MigrationExecutionDto {
    public static final String SERIALIZED_NAME_MIGRATION_PLAN = "migrationPlan";
    @SerializedName(value="migrationPlan")
    private MigrationPlanDto migrationPlan;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    @SerializedName(value="processInstanceQuery")
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    @SerializedName(value="skipCustomListeners")
    private Boolean skipCustomListeners;
    public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
    @SerializedName(value="skipIoMappings")
    private Boolean skipIoMappings;

    public MigrationExecutionDto migrationPlan(MigrationPlanDto migrationPlan) {
        this.migrationPlan = migrationPlan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MigrationPlanDto getMigrationPlan() {
        return this.migrationPlan;
    }

    public void setMigrationPlan(MigrationPlanDto migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    public MigrationExecutionDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public MigrationExecutionDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of process instance ids to migrate.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public MigrationExecutionDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public MigrationExecutionDto skipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value to control whether execution listeners should be invoked during migration.")
    public Boolean getSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public MigrationExecutionDto skipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value to control whether input/output mappings should be executed during migration.")
    public Boolean getSkipIoMappings() {
        return this.skipIoMappings;
    }

    public void setSkipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationExecutionDto migrationExecutionDto = (MigrationExecutionDto)o;
        return Objects.equals(this.migrationPlan, migrationExecutionDto.migrationPlan) && Objects.equals(this.processInstanceIds, migrationExecutionDto.processInstanceIds) && Objects.equals(this.processInstanceQuery, migrationExecutionDto.processInstanceQuery) && Objects.equals(this.skipCustomListeners, migrationExecutionDto.skipCustomListeners) && Objects.equals(this.skipIoMappings, migrationExecutionDto.skipIoMappings);
    }

    public int hashCode() {
        return Objects.hash(this.migrationPlan, this.processInstanceIds, this.processInstanceQuery, this.skipCustomListeners, this.skipIoMappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationExecutionDto {\n");
        sb.append("    migrationPlan: ").append(this.toIndentedString(this.migrationPlan)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    skipCustomListeners: ").append(this.toIndentedString(this.skipCustomListeners)).append("\n");
        sb.append("    skipIoMappings: ").append(this.toIndentedString(this.skipIoMappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

