/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDtoSorting;

@ApiModel(description="A Job definition query which defines a list of Job definitions")
public class JobDefinitionQueryDto {
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_JOB_TYPE = "jobType";
    @SerializedName(value="jobType")
    private String jobType;
    public static final String SERIALIZED_NAME_JOB_CONFIGURATION = "jobConfiguration";
    @SerializedName(value="jobConfiguration")
    private String jobConfiguration;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_WITH_OVERRIDING_JOB_PRIORITY = "withOverridingJobPriority";
    @SerializedName(value="withOverridingJobPriority")
    private Boolean withOverridingJobPriority;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_INCLUDE_JOB_DEFINITIONS_WITHOUT_TENANT_ID = "includeJobDefinitionsWithoutTenantId";
    @SerializedName(value="includeJobDefinitionsWithoutTenantId")
    private Boolean includeJobDefinitionsWithoutTenantId;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<JobDefinitionQueryDtoSorting> sorting = null;

    public JobDefinitionQueryDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job definition id.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobDefinitionQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public JobDefinitionQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which belong to one of the passed activity ids.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public JobDefinitionQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which exist for the given process definition id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobDefinitionQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which exist for the given process definition key.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobDefinitionQueryDto jobType(String jobType) {
        this.jobType = jobType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.")
    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public JobDefinitionQueryDto jobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration.")
    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public JobDefinitionQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active job definitions. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public JobDefinitionQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended job definitions. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public JobDefinitionQueryDto withOverridingJobPriority(Boolean withOverridingJobPriority) {
        this.withOverridingJobPriority = withOverridingJobPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions that have an overriding job priority defined. The only effective value is `true`. If set to `false`, this filter is not applied.")
    public Boolean getWithOverridingJobPriority() {
        return this.withOverridingJobPriority;
    }

    public void setWithOverridingJobPriority(Boolean withOverridingJobPriority) {
        this.withOverridingJobPriority = withOverridingJobPriority;
    }

    public JobDefinitionQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public JobDefinitionQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which belong to one of the passed tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public JobDefinitionQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include job definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public JobDefinitionQueryDto includeJobDefinitionsWithoutTenantId(Boolean includeJobDefinitionsWithoutTenantId) {
        this.includeJobDefinitionsWithoutTenantId = includeJobDefinitionsWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include job definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getIncludeJobDefinitionsWithoutTenantId() {
        return this.includeJobDefinitionsWithoutTenantId;
    }

    public void setIncludeJobDefinitionsWithoutTenantId(Boolean includeJobDefinitionsWithoutTenantId) {
        this.includeJobDefinitionsWithoutTenantId = includeJobDefinitionsWithoutTenantId;
    }

    public JobDefinitionQueryDto sorting(List<JobDefinitionQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public JobDefinitionQueryDto addSortingItem(JobDefinitionQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<JobDefinitionQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.")
    public List<JobDefinitionQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<JobDefinitionQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionQueryDto jobDefinitionQueryDto = (JobDefinitionQueryDto)o;
        return Objects.equals(this.jobDefinitionId, jobDefinitionQueryDto.jobDefinitionId) && Objects.equals(this.activityIdIn, jobDefinitionQueryDto.activityIdIn) && Objects.equals(this.processDefinitionId, jobDefinitionQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobDefinitionQueryDto.processDefinitionKey) && Objects.equals(this.jobType, jobDefinitionQueryDto.jobType) && Objects.equals(this.jobConfiguration, jobDefinitionQueryDto.jobConfiguration) && Objects.equals(this.active, jobDefinitionQueryDto.active) && Objects.equals(this.suspended, jobDefinitionQueryDto.suspended) && Objects.equals(this.withOverridingJobPriority, jobDefinitionQueryDto.withOverridingJobPriority) && Objects.equals(this.tenantIdIn, jobDefinitionQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, jobDefinitionQueryDto.withoutTenantId) && Objects.equals(this.includeJobDefinitionsWithoutTenantId, jobDefinitionQueryDto.includeJobDefinitionsWithoutTenantId) && Objects.equals(this.sorting, jobDefinitionQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.jobDefinitionId, this.activityIdIn, this.processDefinitionId, this.processDefinitionKey, this.jobType, this.jobConfiguration, this.active, this.suspended, this.withOverridingJobPriority, this.tenantIdIn, this.withoutTenantId, this.includeJobDefinitionsWithoutTenantId, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionQueryDto {\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString(this.jobType)).append("\n");
        sb.append("    jobConfiguration: ").append(this.toIndentedString(this.jobConfiguration)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    withOverridingJobPriority: ").append(this.toIndentedString(this.withOverridingJobPriority)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    includeJobDefinitionsWithoutTenantId: ").append(this.toIndentedString(this.includeJobDefinitionsWithoutTenantId)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

