/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobDefinitionPriorityDto {
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Long priority;
    public static final String SERIALIZED_NAME_INCLUDE_JOBS = "includeJobs";
    @SerializedName(value="includeJobs")
    private Boolean includeJobs;

    public JobDefinitionPriorityDto priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The new execution priority number for jobs of the given definition. The definition's priority can be reset by using the value `null`. In that case, the job definition's priority no longer applies but a new job's priority is determined as specified in the process model.")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public JobDefinitionPriorityDto includeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value indicating whether existing jobs of the given definition should receive the priority as well. Default value is `false`. Can only be `true` when the __priority__ parameter is not `null`.")
    public Boolean getIncludeJobs() {
        return this.includeJobs;
    }

    public void setIncludeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionPriorityDto jobDefinitionPriorityDto = (JobDefinitionPriorityDto)o;
        return Objects.equals(this.priority, jobDefinitionPriorityDto.priority) && Objects.equals(this.includeJobs, jobDefinitionPriorityDto.includeJobs);
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.includeJobs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionPriorityDto {\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    includeJobs: ").append(this.toIndentedString(this.includeJobs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

