/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobDefinitionDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_JOB_TYPE = "jobType";
    @SerializedName(value="jobType")
    private String jobType;
    public static final String SERIALIZED_NAME_JOB_CONFIGURATION = "jobConfiguration";
    @SerializedName(value="jobConfiguration")
    private String jobConfiguration;
    public static final String SERIALIZED_NAME_OVERRIDING_JOB_PRIORITY = "overridingJobPriority";
    @SerializedName(value="overridingJobPriority")
    private Long overridingJobPriority;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
    @SerializedName(value="deploymentId")
    private String deploymentId;

    public JobDefinitionDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the job definition.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JobDefinitionDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition this job definition is associated with.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobDefinitionDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition this job definition is associated with.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobDefinitionDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity this job definition is associated with.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public JobDefinitionDto jobType(String jobType) {
        this.jobType = jobType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.")
    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public JobDefinitionDto jobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.")
    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public JobDefinitionDto overridingJobPriority(Long overridingJobPriority) {
        this.overridingJobPriority = overridingJobPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution priority defined for jobs that are created based on this definition. May be `null` when the priority has not been overridden on the job definition level.")
    public Long getOverridingJobPriority() {
        return this.overridingJobPriority;
    }

    public void setOverridingJobPriority(Long overridingJobPriority) {
        this.overridingJobPriority = overridingJobPriority;
    }

    public JobDefinitionDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether this job definition is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public JobDefinitionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant this job definition is associated with.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public JobDefinitionDto deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionDto jobDefinitionDto = (JobDefinitionDto)o;
        return Objects.equals(this.id, jobDefinitionDto.id) && Objects.equals(this.processDefinitionId, jobDefinitionDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobDefinitionDto.processDefinitionKey) && Objects.equals(this.activityId, jobDefinitionDto.activityId) && Objects.equals(this.jobType, jobDefinitionDto.jobType) && Objects.equals(this.jobConfiguration, jobDefinitionDto.jobConfiguration) && Objects.equals(this.overridingJobPriority, jobDefinitionDto.overridingJobPriority) && Objects.equals(this.suspended, jobDefinitionDto.suspended) && Objects.equals(this.tenantId, jobDefinitionDto.tenantId) && Objects.equals(this.deploymentId, jobDefinitionDto.deploymentId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionId, this.processDefinitionKey, this.activityId, this.jobType, this.jobConfiguration, this.overridingJobPriority, this.suspended, this.tenantId, this.deploymentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString(this.jobType)).append("\n");
        sb.append("    jobConfiguration: ").append(this.toIndentedString(this.jobConfiguration)).append("\n");
        sb.append("    overridingJobPriority: ").append(this.toIndentedString(this.overridingJobPriority)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

