/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.FetchExternalTaskTopicDto;

public class FetchExternalTasksDto {
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;
    public static final String SERIALIZED_NAME_MAX_TASKS = "maxTasks";
    @SerializedName(value="maxTasks")
    private Integer maxTasks;
    public static final String SERIALIZED_NAME_USE_PRIORITY = "usePriority";
    @SerializedName(value="usePriority")
    private Boolean usePriority;
    public static final String SERIALIZED_NAME_ASYNC_RESPONSE_TIMEOUT = "asyncResponseTimeout";
    @SerializedName(value="asyncResponseTimeout")
    private Long asyncResponseTimeout;
    public static final String SERIALIZED_NAME_TOPICS = "topics";
    @SerializedName(value="topics")
    private List<FetchExternalTaskTopicDto> topics = null;

    public FetchExternalTasksDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @ApiModelProperty(required=true, value="**Mandatory.** The id of the worker on which behalf tasks are fetched. The returned tasks are locked for that worker and can only be completed when providing the same worker id.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public FetchExternalTasksDto maxTasks(Integer maxTasks) {
        this.maxTasks = maxTasks;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="**Mandatory.** The maximum number of tasks to return.")
    public Integer getMaxTasks() {
        return this.maxTasks;
    }

    public void setMaxTasks(Integer maxTasks) {
        this.maxTasks = maxTasks;
    }

    public FetchExternalTasksDto usePriority(Boolean usePriority) {
        this.usePriority = usePriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A `boolean` value, which indicates whether the task should be fetched based on its priority or arbitrarily.")
    public Boolean getUsePriority() {
        return this.usePriority;
    }

    public void setUsePriority(Boolean usePriority) {
        this.usePriority = usePriority;
    }

    public FetchExternalTasksDto asyncResponseTimeout(Long asyncResponseTimeout) {
        this.asyncResponseTimeout = asyncResponseTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [Long Polling](https://docs.camunda.org/manual/7.17/user-guide/process-engine/external-tasks/#long-polling-to-fetch-and-lock-external-tasks) timeout in milliseconds.  **Note:** The value cannot be set larger than 1.800.000 milliseconds (corresponds to 30 minutes).")
    public Long getAsyncResponseTimeout() {
        return this.asyncResponseTimeout;
    }

    public void setAsyncResponseTimeout(Long asyncResponseTimeout) {
        this.asyncResponseTimeout = asyncResponseTimeout;
    }

    public FetchExternalTasksDto topics(List<FetchExternalTaskTopicDto> topics) {
        this.topics = topics;
        return this;
    }

    public FetchExternalTasksDto addTopicsItem(FetchExternalTaskTopicDto topicsItem) {
        if (this.topics == null) {
            this.topics = new ArrayList<FetchExternalTaskTopicDto>();
        }
        this.topics.add(topicsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of topic objects for which external tasks should be fetched. The returned tasks may be arbitrarily distributed among these topics. Each topic object has the following properties:")
    public List<FetchExternalTaskTopicDto> getTopics() {
        return this.topics;
    }

    public void setTopics(List<FetchExternalTaskTopicDto> topics) {
        this.topics = topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchExternalTasksDto fetchExternalTasksDto = (FetchExternalTasksDto)o;
        return Objects.equals(this.workerId, fetchExternalTasksDto.workerId) && Objects.equals(this.maxTasks, fetchExternalTasksDto.maxTasks) && Objects.equals(this.usePriority, fetchExternalTasksDto.usePriority) && Objects.equals(this.asyncResponseTimeout, fetchExternalTasksDto.asyncResponseTimeout) && Objects.equals(this.topics, fetchExternalTasksDto.topics);
    }

    public int hashCode() {
        return Objects.hash(this.workerId, this.maxTasks, this.usePriority, this.asyncResponseTimeout, this.topics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FetchExternalTasksDto {\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    maxTasks: ").append(this.toIndentedString(this.maxTasks)).append("\n");
        sb.append("    usePriority: ").append(this.toIndentedString(this.usePriority)).append("\n");
        sb.append("    asyncResponseTimeout: ").append(this.toIndentedString(this.asyncResponseTimeout)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

