/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExecutionQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

@ApiModel(description="A Execution instance query which defines a list of Execution instances")
public class ExecutionQueryDto {
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_SIGNAL_EVENT_SUBSCRIPTION_NAME = "signalEventSubscriptionName";
    @SerializedName(value="signalEventSubscriptionName")
    private String signalEventSubscriptionName;
    public static final String SERIALIZED_NAME_MESSAGE_EVENT_SUBSCRIPTION_NAME = "messageEventSubscriptionName";
    @SerializedName(value="messageEventSubscriptionName")
    private String messageEventSubscriptionName;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_INCIDENT_ID = "incidentId";
    @SerializedName(value="incidentId")
    private String incidentId;
    public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
    @SerializedName(value="incidentType")
    private String incidentType;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
    @SerializedName(value="incidentMessage")
    private String incidentMessage;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
    @SerializedName(value="incidentMessageLike")
    private String incidentMessageLike;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private List<VariableQueryParameterDto> variables = null;
    public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
    @SerializedName(value="processVariables")
    private List<VariableQueryParameterDto> processVariables = null;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<ExecutionQueryDtoSorting> sorting = null;

    public ExecutionQueryDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the business key of the process instances the executions belong to.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public ExecutionQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process definition the executions run on.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ExecutionQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the process definition the executions run on.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ExecutionQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the process instance the execution belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ExecutionQueryDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the activity the execution currently executes.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ExecutionQueryDto signalEventSubscriptionName(String signalEventSubscriptionName) {
        this.signalEventSubscriptionName = signalEventSubscriptionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select only those executions that expect a signal of the given name.")
    public String getSignalEventSubscriptionName() {
        return this.signalEventSubscriptionName;
    }

    public void setSignalEventSubscriptionName(String signalEventSubscriptionName) {
        this.signalEventSubscriptionName = signalEventSubscriptionName;
    }

    public ExecutionQueryDto messageEventSubscriptionName(String messageEventSubscriptionName) {
        this.messageEventSubscriptionName = messageEventSubscriptionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select only those executions that expect a message of the given name.")
    public String getMessageEventSubscriptionName() {
        return this.messageEventSubscriptionName;
    }

    public void setMessageEventSubscriptionName(String messageEventSubscriptionName) {
        this.messageEventSubscriptionName = messageEventSubscriptionName;
    }

    public ExecutionQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active executions. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ExecutionQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended executions. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ExecutionQueryDto incidentId(String incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident id.")
    public String getIncidentId() {
        return this.incidentId;
    }

    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    public ExecutionQueryDto incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.")
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public ExecutionQueryDto incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message. Exact match.")
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public ExecutionQueryDto incidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message that the parameter is a substring of.")
    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    public ExecutionQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public ExecutionQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a  list of tenant ids. An execution must have one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public ExecutionQueryDto variables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
        return this;
    }

    public ExecutionQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<VariableQueryParameterDto>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array to only include executions that have variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.")
    public List<VariableQueryParameterDto> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public ExecutionQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
        return this;
    }

    public ExecutionQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
        if (this.processVariables == null) {
            this.processVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.processVariables.add(processVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to.")
    public List<VariableQueryParameterDto> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    public ExecutionQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable names provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public ExecutionQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable values provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public ExecutionQueryDto sorting(List<ExecutionQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public ExecutionQueryDto addSortingItem(ExecutionQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<ExecutionQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint")
    public List<ExecutionQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<ExecutionQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionQueryDto executionQueryDto = (ExecutionQueryDto)o;
        return Objects.equals(this.businessKey, executionQueryDto.businessKey) && Objects.equals(this.processDefinitionId, executionQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, executionQueryDto.processDefinitionKey) && Objects.equals(this.processInstanceId, executionQueryDto.processInstanceId) && Objects.equals(this.activityId, executionQueryDto.activityId) && Objects.equals(this.signalEventSubscriptionName, executionQueryDto.signalEventSubscriptionName) && Objects.equals(this.messageEventSubscriptionName, executionQueryDto.messageEventSubscriptionName) && Objects.equals(this.active, executionQueryDto.active) && Objects.equals(this.suspended, executionQueryDto.suspended) && Objects.equals(this.incidentId, executionQueryDto.incidentId) && Objects.equals(this.incidentType, executionQueryDto.incidentType) && Objects.equals(this.incidentMessage, executionQueryDto.incidentMessage) && Objects.equals(this.incidentMessageLike, executionQueryDto.incidentMessageLike) && Objects.equals(this.tenantIdIn, executionQueryDto.tenantIdIn) && Objects.equals(this.variables, executionQueryDto.variables) && Objects.equals(this.processVariables, executionQueryDto.processVariables) && Objects.equals(this.variableNamesIgnoreCase, executionQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, executionQueryDto.variableValuesIgnoreCase) && Objects.equals(this.sorting, executionQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.businessKey, this.processDefinitionId, this.processDefinitionKey, this.processInstanceId, this.activityId, this.signalEventSubscriptionName, this.messageEventSubscriptionName, this.active, this.suspended, this.incidentId, this.incidentType, this.incidentMessage, this.incidentMessageLike, this.tenantIdIn, this.variables, this.processVariables, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecutionQueryDto {\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    signalEventSubscriptionName: ").append(this.toIndentedString(this.signalEventSubscriptionName)).append("\n");
        sb.append("    messageEventSubscriptionName: ").append(this.toIndentedString(this.messageEventSubscriptionName)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    incidentId: ").append(this.toIndentedString(this.incidentId)).append("\n");
        sb.append("    incidentType: ").append(this.toIndentedString(this.incidentType)).append("\n");
        sb.append("    incidentMessage: ").append(this.toIndentedString(this.incidentMessage)).append("\n");
        sb.append("    incidentMessageLike: ").append(this.toIndentedString(this.incidentMessageLike)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    processVariables: ").append(this.toIndentedString(this.processVariables)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

