/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class CorrelationMessageDto {
    public static final String SERIALIZED_NAME_MESSAGE_NAME = "messageName";
    @SerializedName(value="messageName")
    private String messageName;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId = false;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_CORRELATION_KEYS = "correlationKeys";
    @SerializedName(value="correlationKeys")
    private Map<String, VariableValueDto> correlationKeys = null;
    public static final String SERIALIZED_NAME_LOCAL_CORRELATION_KEYS = "localCorrelationKeys";
    @SerializedName(value="localCorrelationKeys")
    private Map<String, VariableValueDto> localCorrelationKeys = null;
    public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
    @SerializedName(value="processVariables")
    private Map<String, VariableValueDto> processVariables = null;
    public static final String SERIALIZED_NAME_PROCESS_VARIABLES_LOCAL = "processVariablesLocal";
    @SerializedName(value="processVariablesLocal")
    private Map<String, VariableValueDto> processVariablesLocal = null;
    public static final String SERIALIZED_NAME_ALL = "all";
    @SerializedName(value="all")
    private Boolean all = false;
    public static final String SERIALIZED_NAME_RESULT_ENABLED = "resultEnabled";
    @SerializedName(value="resultEnabled")
    private Boolean resultEnabled = false;
    public static final String SERIALIZED_NAME_VARIABLES_IN_RESULT_ENABLED = "variablesInResultEnabled";
    @SerializedName(value="variablesInResultEnabled")
    private Boolean variablesInResultEnabled = false;

    public CorrelationMessageDto messageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the message to deliver.")
    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public CorrelationMessageDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public CorrelationMessageDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a `withoutTenantId`.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public CorrelationMessageDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be `true`, as `false` is the default behavior. Must not be supplied in conjunction with a `tenantId`.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public CorrelationMessageDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to correlate the message to the process instance with the given id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public CorrelationMessageDto correlationKeys(Map<String, VariableValueDto> correlationKeys) {
        this.correlationKeys = correlationKeys;
        return this;
    }

    public CorrelationMessageDto putCorrelationKeysItem(String key, VariableValueDto correlationKeysItem) {
        if (this.correlationKeys == null) {
            this.correlationKeys = new HashMap<String, VariableValueDto>();
        }
        this.correlationKeys.put(key, correlationKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.")
    public Map<String, VariableValueDto> getCorrelationKeys() {
        return this.correlationKeys;
    }

    public void setCorrelationKeys(Map<String, VariableValueDto> correlationKeys) {
        this.correlationKeys = correlationKeys;
    }

    public CorrelationMessageDto localCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
        this.localCorrelationKeys = localCorrelationKeys;
        return this;
    }

    public CorrelationMessageDto putLocalCorrelationKeysItem(String key, VariableValueDto localCorrelationKeysItem) {
        if (this.localCorrelationKeys == null) {
            this.localCorrelationKeys = new HashMap<String, VariableValueDto>();
        }
        this.localCorrelationKeys.put(key, localCorrelationKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.")
    public Map<String, VariableValueDto> getLocalCorrelationKeys() {
        return this.localCorrelationKeys;
    }

    public void setLocalCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
        this.localCorrelationKeys = localCorrelationKeys;
    }

    public CorrelationMessageDto processVariables(Map<String, VariableValueDto> processVariables) {
        this.processVariables = processVariables;
        return this;
    }

    public CorrelationMessageDto putProcessVariablesItem(String key, VariableValueDto processVariablesItem) {
        if (this.processVariables == null) {
            this.processVariables = new HashMap<String, VariableValueDto>();
        }
        this.processVariables.put(key, processVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.")
    public Map<String, VariableValueDto> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(Map<String, VariableValueDto> processVariables) {
        this.processVariables = processVariables;
    }

    public CorrelationMessageDto processVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
        this.processVariablesLocal = processVariablesLocal;
        return this;
    }

    public CorrelationMessageDto putProcessVariablesLocalItem(String key, VariableValueDto processVariablesLocalItem) {
        if (this.processVariablesLocal == null) {
            this.processVariablesLocal = new HashMap<String, VariableValueDto>();
        }
        this.processVariablesLocal.put(key, processVariablesLocalItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of local variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.")
    public Map<String, VariableValueDto> getProcessVariablesLocal() {
        return this.processVariablesLocal;
    }

    public void setProcessVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
        this.processVariablesLocal = processVariablesLocal;
    }

    public CorrelationMessageDto all(Boolean all) {
        this.all = all;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to `false`, the message will be correlated to exactly one entity (execution or process definition). If the value is set to `true`, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.")
    public Boolean getAll() {
        return this.all;
    }

    public void setAll(Boolean all) {
        this.all = all;
    }

    public CorrelationMessageDto resultEnabled(Boolean resultEnabled) {
        this.resultEnabled = resultEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to `true`, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is `false`, which means no result will be returned.")
    public Boolean getResultEnabled() {
        return this.resultEnabled;
    }

    public void setResultEnabled(Boolean resultEnabled) {
        this.resultEnabled = resultEnabled;
    }

    public CorrelationMessageDto variablesInResultEnabled(Boolean variablesInResultEnabled) {
        this.variablesInResultEnabled = variablesInResultEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to `true` in order to use this it.  The default value is `false`, which means the variables will not be returned.")
    public Boolean getVariablesInResultEnabled() {
        return this.variablesInResultEnabled;
    }

    public void setVariablesInResultEnabled(Boolean variablesInResultEnabled) {
        this.variablesInResultEnabled = variablesInResultEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationMessageDto correlationMessageDto = (CorrelationMessageDto)o;
        return Objects.equals(this.messageName, correlationMessageDto.messageName) && Objects.equals(this.businessKey, correlationMessageDto.businessKey) && Objects.equals(this.tenantId, correlationMessageDto.tenantId) && Objects.equals(this.withoutTenantId, correlationMessageDto.withoutTenantId) && Objects.equals(this.processInstanceId, correlationMessageDto.processInstanceId) && Objects.equals(this.correlationKeys, correlationMessageDto.correlationKeys) && Objects.equals(this.localCorrelationKeys, correlationMessageDto.localCorrelationKeys) && Objects.equals(this.processVariables, correlationMessageDto.processVariables) && Objects.equals(this.processVariablesLocal, correlationMessageDto.processVariablesLocal) && Objects.equals(this.all, correlationMessageDto.all) && Objects.equals(this.resultEnabled, correlationMessageDto.resultEnabled) && Objects.equals(this.variablesInResultEnabled, correlationMessageDto.variablesInResultEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.messageName, this.businessKey, this.tenantId, this.withoutTenantId, this.processInstanceId, this.correlationKeys, this.localCorrelationKeys, this.processVariables, this.processVariablesLocal, this.all, this.resultEnabled, this.variablesInResultEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorrelationMessageDto {\n");
        sb.append("    messageName: ").append(this.toIndentedString(this.messageName)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    correlationKeys: ").append(this.toIndentedString(this.correlationKeys)).append("\n");
        sb.append("    localCorrelationKeys: ").append(this.toIndentedString(this.localCorrelationKeys)).append("\n");
        sb.append("    processVariables: ").append(this.toIndentedString(this.processVariables)).append("\n");
        sb.append("    processVariablesLocal: ").append(this.toIndentedString(this.processVariablesLocal)).append("\n");
        sb.append("    all: ").append(this.toIndentedString(this.all)).append("\n");
        sb.append("    resultEnabled: ").append(this.toIndentedString(this.resultEnabled)).append("\n");
        sb.append("    variablesInResultEnabled: ").append(this.toIndentedString(this.variablesInResultEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

