/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class AuthorizationDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    private List<String> permissions = null;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
    @SerializedName(value="groupId")
    private String groupId;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    private Integer resourceType;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    private String resourceId;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;

    public AuthorizationDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the authorization.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuthorizationDto type(Integer type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the authorization (0=global, 1=grant, 2=revoke). See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AuthorizationDto permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationDto addPermissionsItem(String permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Strings holding the permissions provided by this authorization.")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public AuthorizationDto userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AuthorizationDto groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the group this authorization has been created for.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public AuthorizationDto resourceType(Integer resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.")
    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationDto resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The resource Id. The value `*` represents an authorization ranging over all instances of a resource.")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public AuthorizationDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The removal time indicates the date a historic instance authorization is cleaned up. A removal time can only be assigned to a historic instance authorization. Can be `null` when not related to a historic instance resource or when the removal time strategy is end and the root process instance is not finished. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public AuthorizationDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance the historic instance authorization is related to. Can be `null` if not related to a historic instance resource.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationDto authorizationDto = (AuthorizationDto)o;
        return Objects.equals(this.id, authorizationDto.id) && Objects.equals(this.type, authorizationDto.type) && Objects.equals(this.permissions, authorizationDto.permissions) && Objects.equals(this.userId, authorizationDto.userId) && Objects.equals(this.groupId, authorizationDto.groupId) && Objects.equals(this.resourceType, authorizationDto.resourceType) && Objects.equals(this.resourceId, authorizationDto.resourceId) && Objects.equals(this.removalTime, authorizationDto.removalTime) && Objects.equals(this.rootProcessInstanceId, authorizationDto.rootProcessInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.permissions, this.userId, this.groupId, this.resourceType, this.resourceId, this.removalTime, this.rootProcessInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

