/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;

/**
 * ExternalTaskFailureDtoAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class ExternalTaskFailureDtoAllOf {
  public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
  @SerializedName(SERIALIZED_NAME_ERROR_MESSAGE)
  private String errorMessage;

  public static final String SERIALIZED_NAME_ERROR_DETAILS = "errorDetails";
  @SerializedName(SERIALIZED_NAME_ERROR_DETAILS)
  private String errorDetails;

  public static final String SERIALIZED_NAME_RETRIES = "retries";
  @SerializedName(SERIALIZED_NAME_RETRIES)
  private Integer retries;

  public static final String SERIALIZED_NAME_RETRY_TIMEOUT = "retryTimeout";
  @SerializedName(SERIALIZED_NAME_RETRY_TIMEOUT)
  private Long retryTimeout;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private Map<String, VariableValueDto> variables = null;

  public static final String SERIALIZED_NAME_LOCAL_VARIABLES = "localVariables";
  @SerializedName(SERIALIZED_NAME_LOCAL_VARIABLES)
  private Map<String, VariableValueDto> localVariables = null;


  public ExternalTaskFailureDtoAllOf errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * An message indicating the reason of the failure.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An message indicating the reason of the failure.")

  public String getErrorMessage() {
    return errorMessage;
  }


  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }


  public ExternalTaskFailureDtoAllOf errorDetails(String errorDetails) {
    
    this.errorDetails = errorDetails;
    return this;
  }

   /**
   * A detailed error description.
   * @return errorDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A detailed error description.")

  public String getErrorDetails() {
    return errorDetails;
  }


  public void setErrorDetails(String errorDetails) {
    this.errorDetails = errorDetails;
  }


  public ExternalTaskFailureDtoAllOf retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * A number of how often the task should be retried. Must be &gt;&#x3D; 0. If this is 0, an incident is created and the task cannot be fetched anymore unless the retries are increased again. The incident&#39;s message is set to the &#x60;errorMessage&#x60; parameter.
   * @return retries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A number of how often the task should be retried. Must be >= 0. If this is 0, an incident is created and the task cannot be fetched anymore unless the retries are increased again. The incident's message is set to the `errorMessage` parameter.")

  public Integer getRetries() {
    return retries;
  }


  public void setRetries(Integer retries) {
    this.retries = retries;
  }


  public ExternalTaskFailureDtoAllOf retryTimeout(Long retryTimeout) {
    
    this.retryTimeout = retryTimeout;
    return this;
  }

   /**
   * A timeout in milliseconds before the external task becomes available again for fetching. Must be &gt;&#x3D; 0.
   * @return retryTimeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A timeout in milliseconds before the external task becomes available again for fetching. Must be >= 0.")

  public Long getRetryTimeout() {
    return retryTimeout;
  }


  public void setRetryTimeout(Long retryTimeout) {
    this.retryTimeout = retryTimeout;
  }


  public ExternalTaskFailureDtoAllOf variables(Map<String, VariableValueDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public ExternalTaskFailureDtoAllOf putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<String, VariableValueDto>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

   /**
   * A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object with the following properties:
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object with the following properties:")

  public Map<String, VariableValueDto> getVariables() {
    return variables;
  }


  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = variables;
  }


  public ExternalTaskFailureDtoAllOf localVariables(Map<String, VariableValueDto> localVariables) {
    
    this.localVariables = localVariables;
    return this;
  }

  public ExternalTaskFailureDtoAllOf putLocalVariablesItem(String key, VariableValueDto localVariablesItem) {
    if (this.localVariables == null) {
      this.localVariables = new HashMap<String, VariableValueDto>();
    }
    this.localVariables.put(key, localVariablesItem);
    return this;
  }

   /**
   * A JSON object containing local variable key-value pairs. Local variables are set only in the scope of external task. Each key is a variable name and each value a JSON variable value object with the following properties:
   * @return localVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON object containing local variable key-value pairs. Local variables are set only in the scope of external task. Each key is a variable name and each value a JSON variable value object with the following properties:")

  public Map<String, VariableValueDto> getLocalVariables() {
    return localVariables;
  }


  public void setLocalVariables(Map<String, VariableValueDto> localVariables) {
    this.localVariables = localVariables;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalTaskFailureDtoAllOf externalTaskFailureDtoAllOf = (ExternalTaskFailureDtoAllOf) o;
    return Objects.equals(this.errorMessage, externalTaskFailureDtoAllOf.errorMessage) &&
        Objects.equals(this.errorDetails, externalTaskFailureDtoAllOf.errorDetails) &&
        Objects.equals(this.retries, externalTaskFailureDtoAllOf.retries) &&
        Objects.equals(this.retryTimeout, externalTaskFailureDtoAllOf.retryTimeout) &&
        Objects.equals(this.variables, externalTaskFailureDtoAllOf.variables) &&
        Objects.equals(this.localVariables, externalTaskFailureDtoAllOf.localVariables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorMessage, errorDetails, retries, retryTimeout, variables, localVariables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalTaskFailureDtoAllOf {\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    retryTimeout: ").append(toIndentedString(retryTimeout)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    localVariables: ").append(toIndentedString(localVariables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

