/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.rest.client.dto.ExecutionQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

/**
 * A Execution instance query which defines a list of Execution instances
 */
@ApiModel(description = "A Execution instance query which defines a list of Execution instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class ExecutionQueryDto {
  public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
  @SerializedName(SERIALIZED_NAME_BUSINESS_KEY)
  private String businessKey;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_SIGNAL_EVENT_SUBSCRIPTION_NAME = "signalEventSubscriptionName";
  @SerializedName(SERIALIZED_NAME_SIGNAL_EVENT_SUBSCRIPTION_NAME)
  private String signalEventSubscriptionName;

  public static final String SERIALIZED_NAME_MESSAGE_EVENT_SUBSCRIPTION_NAME = "messageEventSubscriptionName";
  @SerializedName(SERIALIZED_NAME_MESSAGE_EVENT_SUBSCRIPTION_NAME)
  private String messageEventSubscriptionName;

  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
  @SerializedName(SERIALIZED_NAME_SUSPENDED)
  private Boolean suspended;

  public static final String SERIALIZED_NAME_INCIDENT_ID = "incidentId";
  @SerializedName(SERIALIZED_NAME_INCIDENT_ID)
  private String incidentId;

  public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
  @SerializedName(SERIALIZED_NAME_INCIDENT_TYPE)
  private String incidentType;

  public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
  @SerializedName(SERIALIZED_NAME_INCIDENT_MESSAGE)
  private String incidentMessage;

  public static final String SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
  @SerializedName(SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE)
  private String incidentMessageLike;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private List<VariableQueryParameterDto> variables = null;

  public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
  @SerializedName(SERIALIZED_NAME_PROCESS_VARIABLES)
  private List<VariableQueryParameterDto> processVariables = null;

  public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE)
  private Boolean variableNamesIgnoreCase;

  public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE)
  private Boolean variableValuesIgnoreCase;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<ExecutionQueryDtoSorting> sorting = null;


  public ExecutionQueryDto businessKey(String businessKey) {
    
    this.businessKey = businessKey;
    return this;
  }

   /**
   * Filter by the business key of the process instances the executions belong to.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the business key of the process instances the executions belong to.")

  public String getBusinessKey() {
    return businessKey;
  }


  public void setBusinessKey(String businessKey) {
    this.businessKey = businessKey;
  }


  public ExecutionQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by the process definition the executions run on.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the process definition the executions run on.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public ExecutionQueryDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the process definition the executions run on.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the process definition the executions run on.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public ExecutionQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by the id of the process instance the execution belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the process instance the execution belongs to.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public ExecutionQueryDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * Filter by the id of the activity the execution currently executes.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the activity the execution currently executes.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public ExecutionQueryDto signalEventSubscriptionName(String signalEventSubscriptionName) {
    
    this.signalEventSubscriptionName = signalEventSubscriptionName;
    return this;
  }

   /**
   * Select only those executions that expect a signal of the given name.
   * @return signalEventSubscriptionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Select only those executions that expect a signal of the given name.")

  public String getSignalEventSubscriptionName() {
    return signalEventSubscriptionName;
  }


  public void setSignalEventSubscriptionName(String signalEventSubscriptionName) {
    this.signalEventSubscriptionName = signalEventSubscriptionName;
  }


  public ExecutionQueryDto messageEventSubscriptionName(String messageEventSubscriptionName) {
    
    this.messageEventSubscriptionName = messageEventSubscriptionName;
    return this;
  }

   /**
   * Select only those executions that expect a message of the given name.
   * @return messageEventSubscriptionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Select only those executions that expect a message of the given name.")

  public String getMessageEventSubscriptionName() {
    return messageEventSubscriptionName;
  }


  public void setMessageEventSubscriptionName(String messageEventSubscriptionName) {
    this.messageEventSubscriptionName = messageEventSubscriptionName;
  }


  public ExecutionQueryDto active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include active executions. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }


  public ExecutionQueryDto suspended(Boolean suspended) {
    
    this.suspended = suspended;
    return this;
  }

   /**
   * Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include suspended executions. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getSuspended() {
    return suspended;
  }


  public void setSuspended(Boolean suspended) {
    this.suspended = suspended;
  }


  public ExecutionQueryDto incidentId(String incidentId) {
    
    this.incidentId = incidentId;
    return this;
  }

   /**
   * Filter by the incident id.
   * @return incidentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident id.")

  public String getIncidentId() {
    return incidentId;
  }


  public void setIncidentId(String incidentId) {
    this.incidentId = incidentId;
  }


  public ExecutionQueryDto incidentType(String incidentType) {
    
    this.incidentType = incidentType;
    return this;
  }

   /**
   * Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
   * @return incidentType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.")

  public String getIncidentType() {
    return incidentType;
  }


  public void setIncidentType(String incidentType) {
    this.incidentType = incidentType;
  }


  public ExecutionQueryDto incidentMessage(String incidentMessage) {
    
    this.incidentMessage = incidentMessage;
    return this;
  }

   /**
   * Filter by the incident message. Exact match.
   * @return incidentMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident message. Exact match.")

  public String getIncidentMessage() {
    return incidentMessage;
  }


  public void setIncidentMessage(String incidentMessage) {
    this.incidentMessage = incidentMessage;
  }


  public ExecutionQueryDto incidentMessageLike(String incidentMessageLike) {
    
    this.incidentMessageLike = incidentMessageLike;
    return this;
  }

   /**
   * Filter by the incident message that the parameter is a substring of.
   * @return incidentMessageLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident message that the parameter is a substring of.")

  public String getIncidentMessageLike() {
    return incidentMessageLike;
  }


  public void setIncidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = incidentMessageLike;
  }


  public ExecutionQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public ExecutionQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a  list of tenant ids. An execution must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a  list of tenant ids. An execution must have one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public ExecutionQueryDto variables(List<VariableQueryParameterDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public ExecutionQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<VariableQueryParameterDto>();
    }
    this.variables.add(variablesItem);
    return this;
  }

   /**
   * An array to only include executions that have variables with certain values.  The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name (String)&#x60; is the variable name, &#x60;operator (String)&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array to only include executions that have variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.")

  public List<VariableQueryParameterDto> getVariables() {
    return variables;
  }


  public void setVariables(List<VariableQueryParameterDto> variables) {
    this.variables = variables;
  }


  public ExecutionQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
    
    this.processVariables = processVariables;
    return this;
  }

  public ExecutionQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
    if (this.processVariables == null) {
      this.processVariables = new ArrayList<VariableQueryParameterDto>();
    }
    this.processVariables.add(processVariablesItem);
    return this;
  }

   /**
   * An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name (String)&#x60; is the variable name, &#x60;operator (String)&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to.")

  public List<VariableQueryParameterDto> getProcessVariables() {
    return processVariables;
  }


  public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = processVariables;
  }


  public ExecutionQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    return this;
  }

   /**
   * Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match all variable names provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.")

  public Boolean getVariableNamesIgnoreCase() {
    return variableNamesIgnoreCase;
  }


  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }


  public ExecutionQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    return this;
  }

   /**
   * Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match all variable values provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.")

  public Boolean getVariableValuesIgnoreCase() {
    return variableValuesIgnoreCase;
  }


  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }


  public ExecutionQueryDto sorting(List<ExecutionQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public ExecutionQueryDto addSortingItem(ExecutionQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<ExecutionQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the &#x60;/count&#x60; endpoint
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint")

  public List<ExecutionQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<ExecutionQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionQueryDto executionQueryDto = (ExecutionQueryDto) o;
    return Objects.equals(this.businessKey, executionQueryDto.businessKey) &&
        Objects.equals(this.processDefinitionId, executionQueryDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, executionQueryDto.processDefinitionKey) &&
        Objects.equals(this.processInstanceId, executionQueryDto.processInstanceId) &&
        Objects.equals(this.activityId, executionQueryDto.activityId) &&
        Objects.equals(this.signalEventSubscriptionName, executionQueryDto.signalEventSubscriptionName) &&
        Objects.equals(this.messageEventSubscriptionName, executionQueryDto.messageEventSubscriptionName) &&
        Objects.equals(this.active, executionQueryDto.active) &&
        Objects.equals(this.suspended, executionQueryDto.suspended) &&
        Objects.equals(this.incidentId, executionQueryDto.incidentId) &&
        Objects.equals(this.incidentType, executionQueryDto.incidentType) &&
        Objects.equals(this.incidentMessage, executionQueryDto.incidentMessage) &&
        Objects.equals(this.incidentMessageLike, executionQueryDto.incidentMessageLike) &&
        Objects.equals(this.tenantIdIn, executionQueryDto.tenantIdIn) &&
        Objects.equals(this.variables, executionQueryDto.variables) &&
        Objects.equals(this.processVariables, executionQueryDto.processVariables) &&
        Objects.equals(this.variableNamesIgnoreCase, executionQueryDto.variableNamesIgnoreCase) &&
        Objects.equals(this.variableValuesIgnoreCase, executionQueryDto.variableValuesIgnoreCase) &&
        Objects.equals(this.sorting, executionQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionQueryDto {\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    signalEventSubscriptionName: ").append(toIndentedString(signalEventSubscriptionName)).append("\n");
    sb.append("    messageEventSubscriptionName: ").append(toIndentedString(messageEventSubscriptionName)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    incidentId: ").append(toIndentedString(incidentId)).append("\n");
    sb.append("    incidentType: ").append(toIndentedString(incidentType)).append("\n");
    sb.append("    incidentMessage: ").append(toIndentedString(incidentMessage)).append("\n");
    sb.append("    incidentMessageLike: ").append(toIndentedString(incidentMessageLike)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

